/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.social.entity.TPaymentInfo;
import com.yifu.cloud.plus.v1.yifu.social.mapper.TPaymentInfoMapper;
import com.yifu.cloud.plus.v1.yifu.social.service.TPaymentInfoService;
import org.springframework.stereotype.Service;

/**
 * 缴费库
 *
 * @author huyc
 * @date 2022-07-14 18:53:42
 */
@Service
public class TPaymentInfoServiceImpl extends ServiceImpl<TPaymentInfoMapper, TPaymentInfo> implements TPaymentInfoService {
    /**
     * 缴费库简单分页查询
     * @param tPaymentInfo 缴费库
     * @return
     */
    @Override
    public IPage<TPaymentInfo> getTPaymentInfoPage(Page<TPaymentInfo> page, TPaymentInfo tPaymentInfo){
        return baseMapper.getTPaymentInfoPage(page,tPaymentInfo);
    }
}
