package com.yifu.cloud.plus.v1.yifu.social.util;

import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.DateUtil;
import lombok.extern.slf4j.Slf4j;

import java.time.LocalDateTime;

/**
 * 公用方法提取
 *
 * @author fxj
 * @date 2019-09-29
 **/
@Slf4j
public class ServiceUtil {
	private ServiceUtil() {
		throw new IllegalStateException("ServiceUtil class");
	}

	/**
	 * @Description: 返回字符串对应的int值
	 * @Date: 2022/7/18 17:29
	 **/
	public static int convertStringToInt(String num1) {
		if (Common.isEmpty(num1) || !Common.isNumber(num1)) {
			return -1;
		}
		return Integer.parseInt(num1);
	}

	/**
	 * 按派单日期生成生成月份
	 * @Author fxj
	 * @Date 2020-03-25
	 * @param createDate
	 * @return
	 **/
	public static String  initCreateMonth(LocalDateTime createDate, String payMonth){
		if (null == createDate || Common.isEmpty(payMonth) || payMonth.length() != 6){
			return DateUtil.getYearAndMonth(LocalDateTime.now(), 1);
		}
		if (createDate.getYear() < Integer.parseInt(payMonth.substring(0,4))){
			return  payMonth;
		}
		if (createDate.getYear() > Integer.parseInt(payMonth.substring(0,4))){
			return DateUtil.getYearAndMonth(createDate, 1);
		}
		if (createDate.getYear() == Integer.parseInt(payMonth.substring(0,4))){
			if (createDate.getMonthValue() < Integer.parseInt(payMonth.substring(4,6))){
				return  payMonth;
			}
			if (createDate.getMonthValue() >= Integer.parseInt(payMonth.substring(4,6))){
				return DateUtil.getYearAndMonth(createDate, 1);
			}
		}
		return  null;
	}
}
