/*
 * Copyright (c) 2020 yifu4cloud Authors. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.yifu.cloud.plus.v1.yifu.admin.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @Description: 数据权限主表
 * @Author: hgw
 * @Date: 2022/6/7 11:29
 * @return:
 **/
@Schema(description = "数据权限主表")
@Data
@EqualsAndHashCode(callSuper = true)
public class SysDataAuth extends BaseEntity {

	private static final long serialVersionUID = 1L;

	@TableId(value = "id", type = IdType.ASSIGN_ID)
	@Schema(description = "主键")
	private String id;

	/**
	 * 关联对象类型：0分组；1用户
	 */
	@NotNull(message = "关联对象类型不能为空")
	@Schema(description = "关联对象类型：0分组；1用户", required = true)
	private Integer linkType;

	/**
	 * 关联对象id
	 */
	@NotBlank(message = "关联对象id不能为空")
	@Schema(description = "关联对象id", required = true)
	private String linkId;

	/**
	 * 关联对象名称
	 */
	@NotBlank(message = "关联对象名称不能为空")
	@Schema(description = "关联对象名称", required = true)
	private String linkName;

	/**
	 * 创建人权限：0否；1是
	 */
	@NotNull(message = "创建人权限：0否；1是不能为空")
	@Schema(description = "创建人权限：0否；1是", required = true)
	private Integer isCreateAuth;

	/**
	 * 部门权限：0无；1本部门；2自定义部门
	 */
	@NotNull(message = "部门权限：0无；1本部门；2自定义部门不能为空")
	@Schema(description = "部门权限：0无；1本部门；2自定义部门", required = true)
	private Integer isDeptAuth;

	/**
	 * 结算主体权限：0否；1是
	 */
	@NotNull(message = "结算主体权限：0否；1是不能为空")
	@Schema(description = "结算主体权限：0否；1是", required = true)
	private Integer isSettleAuth;

	/**
	 * 自定义sql：0否；1是
	 */
	@NotNull(message = "自定义sql：0否；1是不能为空")
	@Schema(description = "自定义sql：0否；1是", required = true)
	private Integer isDiySql;

}
