/*
 * Copyright (c) 2020 yifu4cloud Authors. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.yifu.cloud.plus.v1.yifu.admin.api.vo;

import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysDataAuth;
import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysDataAuthDeptRel;
import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysDataAuthDiySql;
import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysDataAuthMenuRel;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Description: 数据权限Vo
 * @Author: hgw
 * @Date: 2022/6/8 17:37
 **/
@Schema(description = "数据权限-新增、修改、详情vo")
@Data
public class SysDataAuthVO implements Serializable {

	private static final long serialVersionUID = 1L;

	@Schema(description = "权限主表信息")
	SysDataAuth sysDataAuth;

	@Schema(description = "权限-部门列表")
	List<SysDataAuthDeptRel> authDeptList;
	@Schema(description = "权限-sql列表")
	List<SysDataAuthDiySql> authSqlList;
	// 1：创建人；2：结算主体；3部门
	@Schema(description = "菜单-创建人列表")
	List<SysDataAuthMenuRel> menuCreateList;
	@Schema(description = "菜单-结算主体（项目）列表")
	List<SysDataAuthMenuRel> menuSettleList;
	@Schema(description = "菜单-组织部门列表")
	List<SysDataAuthMenuRel> menuDeptList;

}
