/*
 * Copyright (c) 2020 yifu4cloud Authors. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.yifu.cloud.plus.v1.yifu.admin.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysArea;
import com.yifu.cloud.plus.v1.yifu.admin.api.vo.AreaVo;
import com.yifu.cloud.plus.v1.yifu.admin.service.SysAreaService;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.checkerframework.checker.units.qual.A;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 字典表 前端控制器
 * </p>
 *
 * @author lengleng
 * @since 2019-03-19
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/area")
@Tag(name = "区域管理模块")
public class AreaController {

	private final SysAreaService sysAreaService;

	/**
	 * @Description: 获取所有区域（id，名称）
	 * @Author: hgw
	 * @Date: 2022/6/22 19:33
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.util.Map < java.lang.Integer, java.lang.String>>
	 **/
	@Inner
	@PostMapping("/inner/getAreaToId")
	public R<Map<String, String>> getAreaToId() {
		return sysAreaService.getAreaToId();
	}

	/**
	 * @param
	 * @Description: 获取所有区域（名称，id）
	 * @Author: hgw
	 * @Date: 2022/6/22 19:34
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.util.Map < java.lang.String, java.util.Map < java.lang.String, java.lang.String>>>
	 **/
	@Inner
	@PostMapping("/inner/getAreaToName")
	public R<Map<String, String>> getAreaToName() {
		return sysAreaService.getAreaToName();
	}

	/**
	 * @param
	 * @Description: 获取所有区域list
	 * @Author: hgw
	 * @Date: 2022-7-6 16:42:39
	 **/
	@Inner
	@PostMapping("/inner/getSysAreaList")
	public List<SysArea> getSysAreaList() {
		return sysAreaService.list(Wrappers.<SysArea>query().lambda()
				.eq(SysArea::getStatus, CommonConstants.ZERO_INT).orderByAsc(SysArea::getParentId));
	}
	/**
	 * @param
	 * @Description: 获取所有区域list
	 * @Author: hyc
	 * @Date: 2022-7-21 19:45:24
	 **/
	@Inner
	@PostMapping("/inner/getAreaVo")
	public AreaVo getAreaVo() {
		List<SysArea> aList = sysAreaService.list(Wrappers.<SysArea>query().lambda()
				.eq(SysArea::getStatus, CommonConstants.ZERO_INT).orderByAsc(SysArea::getParentId));
		AreaVo vo = new AreaVo();
		vo.setSysAreaList(aList);
		return vo;
	}

}
