/*
 * Copyright (c) 2020 yifu4cloud Authors. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.yifu.cloud.plus.v1.yifu.admin.service;

import cn.hutool.core.lang.tree.Tree;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysDictItem;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;

import java.util.List;
import java.util.Map;

/**
 * 字典项
 *
 * @author lengleng
 * @date 2019/03/19
 */
public interface SysDictItemService extends IService<SysDictItem> {

	/**
	 * 删除字典项
	 * @param id 字典项ID
	 * @return
	 */
	Boolean removeDictItem(Long id);

	/**
	 * 更新字典项
	 * @param item 字典项
	 * @return
	 */
	Boolean updateDictItem(SysDictItem item);

	/**
	 * 构建树
	 * @param lazy 是否是懒加载
	 * @param parentId 父节点ID
	 * @return
	 */
	List<Tree<Long>> treeMenu(boolean lazy, Long parentId);

	IPage<SysDictItem> pageItem(Page page, SysDictItem sysDictItem);

	R<Boolean> removeDictItemDiy(Long id);

    R<Map<String, Object>> getParentDictItemByTypes(String itemTypes);

	R<Map<String, Object>> getAllDictItem();

	/**
	 * @Description: 获取所有字典数据：用做导入：type,<lable,value>
	 * @Author: hgw
	 * @Date: 2022/6/22 18:04
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.util.Map < java.lang.String, java.util.Map < java.lang.String, java.lang.String>>>
	 **/
	R<Map<String, Map<String, String>>> getDictToLable();

	/**
	 * @Description: 获取所有字典数据：用做导出：type,<value,lable>
	 * @Author: hgw
	 * @Date: 2022/6/22 18:04
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.util.Map < java.lang.String, java.util.Map < java.lang.String, java.lang.String>>>
	 **/
	R<Map<String, Map<String, String>>> getDictToValue();

	Map<String, Object> getAllDictItemSub();

	void clearDictItemCache();

	R<Boolean> saveDiy(SysDictItem sysDictItem);

	R<String> getLableFronValue(String value,String type);
}
