/*
 * Copyright 1999-2018 Alibaba Group Holding Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.alibaba.csp.sentinel.dashboard.datasource.entity.rule;

import java.util.Date;

import com.alibaba.csp.sentinel.slots.block.flow.ClusterFlowConfig;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;

/**
 * @author leyou
 */
public class FlowRuleEntity implements RuleEntity {

	private Long id;

	private String app;

	private String ip;

	private Integer port;

	private String limitApp;

	private String resource;

	/**
	 * 0为线程数;1为qps
	 */
	private Integer grade;

	private Double count;

	/**
	 * 0为直接限流;1为关联限流;2为链路限流
	 ***/
	private Integer strategy;

	private String refResource;

	/**
	 * 0. default, 1. warm up, 2. rate limiter
	 */
	private Integer controlBehavior;

	private Integer warmUpPeriodSec;

	/**
	 * max queueing time in rate limiter behavior
	 */
	private Integer maxQueueingTimeMs;

	private boolean clusterMode;

	/**
	 * Flow rule config for cluster mode.
	 */
	private ClusterFlowConfig clusterConfig;

	private Date gmtCreate;

	private Date gmtModified;

	public static FlowRuleEntity fromFlowRule(String app, String ip, Integer port, FlowRule rule) {
		FlowRuleEntity entity = new FlowRuleEntity();
		entity.setApp(app);
		entity.setIp(ip);
		entity.setPort(port);
		entity.setLimitApp(rule.getLimitApp());
		entity.setResource(rule.getResource());
		entity.setGrade(rule.getGrade());
		entity.setCount(rule.getCount());
		entity.setStrategy(rule.getStrategy());
		entity.setRefResource(rule.getRefResource());
		entity.setControlBehavior(rule.getControlBehavior());
		entity.setWarmUpPeriodSec(rule.getWarmUpPeriodSec());
		entity.setMaxQueueingTimeMs(rule.getMaxQueueingTimeMs());
		entity.setClusterMode(rule.isClusterMode());
		entity.setClusterConfig(rule.getClusterConfig());
		return entity;
	}

	@Override
	public String getIp() {
		return ip;
	}

	public void setIp(String ip) {
		this.ip = ip;
	}

	@Override
	public Integer getPort() {
		return port;
	}

	public void setPort(Integer port) {
		this.port = port;
	}

	@Override
	public String getApp() {
		return app;
	}

	public void setApp(String app) {
		this.app = app;
	}

	@Override
	public Long getId() {
		return id;
	}

	@Override
	public void setId(Long id) {
		this.id = id;
	}

	public String getLimitApp() {
		return limitApp;
	}

	public void setLimitApp(String limitApp) {
		this.limitApp = limitApp;
	}

	public String getResource() {
		return resource;
	}

	public void setResource(String resource) {
		this.resource = resource;
	}

	public Integer getGrade() {
		return grade;
	}

	public void setGrade(Integer grade) {
		this.grade = grade;
	}

	public Double getCount() {
		return count;
	}

	public void setCount(Double count) {
		this.count = count;
	}

	public Integer getStrategy() {
		return strategy;
	}

	public void setStrategy(Integer strategy) {
		this.strategy = strategy;
	}

	public String getRefResource() {
		return refResource;
	}

	public void setRefResource(String refResource) {
		this.refResource = refResource;
	}

	public Integer getControlBehavior() {
		return controlBehavior;
	}

	public void setControlBehavior(Integer controlBehavior) {
		this.controlBehavior = controlBehavior;
	}

	public Integer getWarmUpPeriodSec() {
		return warmUpPeriodSec;
	}

	public void setWarmUpPeriodSec(Integer warmUpPeriodSec) {
		this.warmUpPeriodSec = warmUpPeriodSec;
	}

	public Integer getMaxQueueingTimeMs() {
		return maxQueueingTimeMs;
	}

	public void setMaxQueueingTimeMs(Integer maxQueueingTimeMs) {
		this.maxQueueingTimeMs = maxQueueingTimeMs;
	}

	public boolean isClusterMode() {
		return clusterMode;
	}

	public FlowRuleEntity setClusterMode(boolean clusterMode) {
		this.clusterMode = clusterMode;
		return this;
	}

	public ClusterFlowConfig getClusterConfig() {
		return clusterConfig;
	}

	public FlowRuleEntity setClusterConfig(ClusterFlowConfig clusterConfig) {
		this.clusterConfig = clusterConfig;
		return this;
	}

	@Override
	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	@Override
	public FlowRule toRule() {
		FlowRule flowRule = new FlowRule();
		flowRule.setCount(this.count);
		flowRule.setGrade(this.grade);
		flowRule.setResource(this.resource);
		flowRule.setLimitApp(this.limitApp);
		flowRule.setRefResource(this.refResource);
		flowRule.setStrategy(this.strategy);
		if (this.controlBehavior != null) {
			flowRule.setControlBehavior(controlBehavior);
		}
		if (this.warmUpPeriodSec != null) {
			flowRule.setWarmUpPeriodSec(warmUpPeriodSec);
		}
		if (this.maxQueueingTimeMs != null) {
			flowRule.setMaxQueueingTimeMs(maxQueueingTimeMs);
		}
		flowRule.setClusterMode(clusterMode);
		flowRule.setClusterConfig(clusterConfig);
		return flowRule;
	}

}
