/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.archives.entity.SysAutoDictItem;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TAutoEmpRuleInfo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TAutoMainRel;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TAutoRuleLog;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 项目配置表主表--详情
 *
 * @author fxj
 * @date 2025-03-13 15:15:26
 */
@Data
public class TAutoMainRelDetailVo implements Serializable {
	//项目配置主表
	private TAutoMainRel autoMainRel;
	//档案管理规则配置表
	private TAutoEmpRuleInfo autoEmpRuleInfo;
	//项目配置日志表
	private List<TAutoRuleLog> autoRuleLogs;
	//岗位信息表
	private List<SysAutoDictItem> autoDictItems;
	//项目信息表
	private TSettleDomainSelectVo settleDomainVo;

}
