package com.yifu.cloud.plus.v1.yifu.archives.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.archives.entity.EmployeeRegistrationPre;
import com.yifu.cloud.plus.v1.yifu.archives.vo.EmployeeInfoMsgVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.EmployeeRegistrationPreSearchVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.EmployeeRegistrationPreVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.SendMessageUpdateVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 入职待建档表
 *
 * @author huych
 * @date 2025-03-12 17:14:19
 */
public interface EmployeeRegistrationPreService extends IService<EmployeeRegistrationPre> {
    /**
     * 入职待建档表简单分页查询
     * @param employeeRegistrationPre 入职待建档表
     * @return
     */
    IPage<EmployeeRegistrationPre> getEmployeeRegistrationPrePage(Page<EmployeeRegistrationPre> page, EmployeeRegistrationPreSearchVo employeeRegistrationPre);

	/**
	 * 入职待建档表导出
	 * @param searchVo 入职待建档导出查询vo
	 * @return
	 */
    void listExport(HttpServletResponse response, EmployeeRegistrationPreSearchVo searchVo);

	/**
	 * 入职确认信息导出
	 * @param searchVo 入职确认信息导出查询vo
	 * @return
	 */
	void confirmExport(HttpServletResponse response, EmployeeRegistrationPreSearchVo searchVo);


	/**
	 * 新增入职待建档信息
	 * @param preVo 新增入职待建档vo
	 * @return
	 */
    Boolean saveRegistPreInfo(EmployeeRegistrationPreVo preVo);

	/**
	 * 拒绝入职
	 * @param employeeRegistrationPre 入职待建档表
	 * @return
	 */
    R updateRegistById(EmployeeRegistrationPre employeeRegistrationPre);

	/**
	 * 入职确认信息信息修改
	 * @param employeeRegistrationPre 入职确认信息表
	 * @return
	 */
	R updateCommonInfo(EmployeeRegistrationPre employeeRegistrationPre);

	/**
	 * 数量查询
	 * @param searchVo  type 查询类型 1待办列表 2 监控列表
	 * @return
	 */
	R getListCount(EmployeeRegistrationPreSearchVo searchVo);

	/**
	 * 查询预入职待审核数据
	 * @param pre 入职待建档表
	 * @return
	 */
	R registrationPreAudit(EmployeeRegistrationPre pre);

	/**
	 * 批量发送短信
	 * @param vo
	 * @return
	 */
	R batchSendMessage(List<SendMessageUpdateVo> vo, String type);

	void updatePreStatusToEnd(String deptNo, String empIdcard);

	void updatePreStatusToOne(String deptNo, String empIdcard);

	// 更新为待审核
	void updatePreStatusToTwo(String deptId, String empIdCard);

	R<EmployeeInfoMsgVo> getEmployeeInfo(String cardOrId);



	/**
	 * @param empIdCard 身份证
	 * @param deptId 项目ID
	 * @Description: 判断简档详档，类型1详档2简档（员工类型：代理的是简档，“非代理”且员工合同类型为：空、标准合同、劳务派遣合同、补贴合同 是详档，其余为简档）
	 * @Author: hgw
	 * @Date: 2025/3/20 15:03
	 * @return: java.lang.String
	 **/
	String judgeIsSimple(String empIdCard, String deptId);

	/**
	 * @Description: 获取员工类型与档案地市 -优先从档案维护任务表
	 * @Author: hgw
	 * @Date: 2025/3/21 11:26
	 * @return: com.yifu.cloud.plus.v1.yifu.archives.entity.EmployeeRegistrationPre
	 **/
	EmployeeRegistrationPre getPreInfo(String empIdCard, String deptId);

}
