package com.yifu.cloud.plus.v1.business.query.salary;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 当前部门统计查询条件
 *
 * @author: wangweiguo
 * @date: 2021/9/16
 */
@Setter
@Getter
@ToString
public class TSalaryCurDepartQuery implements Serializable {
    /**
     * 部门id
     */
    @Schema(description ="部门id")
    @NotNull(message = "部门id不能为空")
    private Integer departId;

    /**
     * 工资月份
     */
    @Schema(description = "工资月份 yyyyMM", required = true)
    @NotBlank(message = "查询条件: 工资月份不能为空")
    private String salaryMonth;

    /**
     * 工资月份的上个月
     */
    @Schema(description = "工资月份的上个月，前端无需传该参数")
    private String lastSalaryMonth;

}
