package com.yifu.cloud.plus.v1.business.service.system;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.business.entity.system.TBusWarningEmployee;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;

import java.util.List;


/**
 * B端短信发送记录表
 *
 * @author hgw
 * @date 2021-08-23 16:27:34
 */
public interface TBusWarningEmployeeService extends IService<TBusWarningEmployee> {

     /**
      * B端短信发送记录表简单分页查询
      *
      * @param tBusWarningEmployee B端短信发送记录表
      * @return
      */
     IPage<TBusWarningEmployee> getTBusWarningEmployeePage(Page<TBusWarningEmployee> page, TBusWarningEmployee tBusWarningEmployee);

     /**
      * @param dateStr
      * @Description: 获取list
      * @Author: hgw
      * @Date: 2021/8/24 18:09
      * @return: java.util.List<com.yifu.cloud.v1.hrobusiness.api.entity.system.TBusWarningEmployee>
      **/
     List<TBusWarningEmployee> getTBusWarningEmployeeListToday(String dateStr);

     /**
      * @param bizId
      * @Description: 获取list-根据bizId
      * @Author: hgw
      * @Date: 2021/8/24 18:08
      * @return: java.util.List<com.yifu.cloud.v1.hrobusiness.api.entity.system.TBusWarningEmployee>
      **/
     List<TBusWarningEmployee> getByBizId(String bizId);

     /**
      * @param smsEmployee
      * @Description: 单个发送
      * @Author: hgw
      * @Date: 2021/5/10 10:23
      * @return: com.yifu.cloud.v1.common.core.util.R<java.lang.String>
      **/
     R<String> sendBusSms(TBusWarningEmployee smsEmployee);

     /**
      * @param warningId
      * @param userId
      * @param bizId
      * @Description: 复审到期日
      * @Author: hgw
      * @Date: 2021/8/24 17:51
      * @return: int
      **/
     int insertByReviewDate(String warningId, Integer userId, String bizId, Integer days);

     /**
      * @param warningId
      * @param userId
      * @param bizId
      * @Description: 证件到期日
      * @Author: hgw
      * @Date: 2021/8/24 17:51
      * @return: int
      **/
     int insertByTermValidityEnd(String warningId, Integer userId, String bizId, Integer days);

     /**
      * @param warningId
      * @param userId
      * @param bizId
      * @Description: 年假未休时长
      * @Author: hgw
      * @Date: 2021/8/24 17:51
      * @return: int
      **/
     int insertByYearVacation(String warningId, Integer userId, String bizId);

     /**
      * @Description: 获取假期结束人员姓名
      * @Author: hgw
      * @Date: 2021/8/25 13:14
      * @return: java.lang.String
      **/
     String getVacationInfoEmpName();

	 String getVacationEmpName();

}
