package com.yifu.cloud.plus.v1.yifu.common.dapr.util;

import com.alibaba.fastjson.JSON;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.SecurityConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.dapr.config.DaprSocialProperties;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.EkpInsuranceViewVo;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.EkpSocialViewVo;
import com.yifu.cloud.plus.v1.yifu.salary.vo.*;
import com.yifu.cloud.plus.v1.yifu.social.entity.TIncomeDetail;
import com.yifu.cloud.plus.v1.yifu.social.entity.TPaymentInfo;
import com.yifu.cloud.plus.v1.yifu.social.vo.TIncomeDetailReturnVo;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

import java.util.List;

/**
 * @Author fxj
 * @Date 2022-07-18
 * @Description
 * @Version 1.0
 */
@Log4j2
@EnableConfigurationProperties(DaprSocialProperties.class)
public class SocialDaprUtils {

	@Autowired
	private DaprSocialProperties daprProperties;

	/**
	 * @Author fxj
	 * @Description 去缴费库查询查询这些人社保是否存在
	 * @Date 17:38 2022/8/16
	 * @Param
	 * @return
	**/
	public R<HaveSalaryNoSocialVo> getPaymentinfoListByEmpdIdCard(List<String> idCards, String settleMonth) {
		HaveSalaryNoSocialSearchVo searchVo = new HaveSalaryNoSocialSearchVo();
		searchVo.setIdCards(idCards);
		searchVo.setSettleMonth(settleMonth);
		R<HaveSalaryNoSocialVo> noSocialVoR = HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),"/tpaymentinfo/inner/listByEmpdIdCard", JSON.toJSONString(searchVo), HaveSalaryNoSocialVo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(noSocialVoR)){
			return R.failed("查询人员社保是否存在失败！");
		}
		return noSocialVoR;
	}

	/**
	 * @Author huyc
	 * @Description 去缴费库查询查询这些人社保是否存在
	 * @Date 17:38 2022/8/15
	 * @Param
	 * @return
	 **/
	public void updatePaymentSocialAndFound(UpdateSocialFoundVo infoVo) {
		HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),"/tpaymentinfo/inner/updatePaymentSocialAndFound", JSON.toJSONString(infoVo), Object.class, SecurityConstants.FROM_IN);
	}

	/**
	 * @Author huyc
	 * @Description 更新预估库
	 * @Date 2022/8/15
	 * @Param
	 * @return
	 **/
	public void updateForSocialAndFound(UpdateSocialFoundVo infoVo) {
		HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),"/tforecastlibrary/inner/updateForSocialAndFound", JSON.toJSONString(infoVo), Object.class, SecurityConstants.FROM_IN);
	}

	/**
	 * @Author huyc
	 * @Description 更新社保公积金明细
	 * @Date 2022/8/15
	 * @Param
	 * @return
	 **/
	public void updateSocialAndFoundInfo(UpdateSocialFoundVo infoVo) {
		HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),"/tsocialfundinfo/inner/updateSocialAndFoundInfo", JSON.toJSONString(infoVo), Object.class, SecurityConstants.FROM_IN);
	}

	/**
	 * @Author huyc
	 * @Description 查询人员收入数据
	 * @Date 2022/9/2
	 * @Param
	 * @return
	 **/
	public R<TIncomeDetailReturnVo> getTIncomeDetailList(TIncomeDetail infoVo) {
		R<TIncomeDetailReturnVo> listVo = HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),"/tincomedetail/inner/getTIncomeDetailList", JSON.toJSONString(infoVo), TIncomeDetailReturnVo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(listVo)){
			return R.failed("查询人员收入数据失败！");
		}
		return listVo;
	}

	/**
	 * @Author huyc
	 * @Description 生成收入数据
	 * @Date 2022/9/2
	 * @Param
	 * @return
	 **/
	public R<Boolean> createTIncomeDetail(TIncomeDetail infoVo) {
		return HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),"/tincome/inner/saveDetail", JSON.toJSONString(infoVo), Boolean.class, SecurityConstants.FROM_IN);
	}

	/**
	 * @Author huyc
	 * @Description 查询人员缴费库数据
	 * @Date 2022/9/2
	 * @Param
	 * @return
	 **/
	public R<TPaymentVo> getPaymentSocialAndFound(TPaymentInfo infoVo) {
		R<TPaymentVo> listVo = HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),"/tpaymentinfo/inner/getPaymentSocialAndFound", JSON.toJSONString(infoVo), TPaymentVo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(listVo)){
			return R.failed("查询人员缴费库数据失败！");
		}
		return listVo;
	}

	/**
	 * @Author huyc
	 * @Description 通过收入id删除收入数据
	 * @Date 2022/9/2
	 * @Param
	 * @return
	 **/
	public void deleteById(TIncomeDetail infoVo) {
		HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),"/tincomedetail/inner/deleteById", JSON.toJSONString(infoVo), Object.class, SecurityConstants.FROM_IN);
	}

	/**
	 * @Author huyc
	 * @Description 更新结算信息
	 * @Date 17:38 2022/12/26
	 * @Param
	 * @return
	 **/
	public R<Boolean> updateSocialSettleStatus(List<EkpSocialViewVo> infoVo) {
		return HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),"/tpaymentinfo/inner/updateSocialSettleStatus", JSON.toJSONString(infoVo), Boolean.class, SecurityConstants.FROM_IN);
	}

	/**
	 * @Author huyc
	 * @Description 更新结算信息
	 * @Date 17:38 2022/12/26
	 * @Param
	 * @return
	 **/
	public R<Boolean> updateIncomeSettleStatus(List<EkpInsuranceViewVo> infoVo) {
		return HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),"/tincome/inner/updateIncomeSettleStatus", JSON.toJSONString(infoVo), Boolean.class, SecurityConstants.FROM_IN);
	}

	/**
	 * @Author huyc
	 * @Description 判断是否存在正常的工伤缴费
	 * @Date 16:38 2025/1/15
	 * @Param
	 * @return
	 **/
	public R<Boolean> selectExitSocialInjury(TInsuranceUnpurchasePersonCardVo cardVo) {
		return HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),"/tsocialfundinfo/inner/selectExitSocialInjury", JSON.toJSONString(cardVo), Boolean.class, SecurityConstants.FROM_IN);
	}

	/**
	 * @Description: 查询社保已购买的身份证
	 * @Author: hgw
	 * @Date: 2025/1/15 16:11
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.Boolean>
	 **/
	public R<ListStringVo> selectWorkInjuryHandleAll() {
		return HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId()
				,"/tsocialfundinfo/inner/selectWorkInjuryHandleAll", null, ListStringVo.class, SecurityConstants.FROM_IN);
	}

}
