package com.yifu.cloud.plus.v1.yifu.insurances.entity;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.baomidou.mybatisplus.annotation.*;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;


/**
 * @author licancan
 * @description 商险明细表 t_insurance_detail
 * @date 2022-07-18 16:20:16
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_insurance_detail")
@Schema(description = "商险明细表")
public class TInsuranceDetail extends BaseEntity {
    /**
     * 主键
     */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "主键")
    private String id;

    /**
     * 员工姓名
     */
	@Schema(description = "员工姓名")
    private String empName;

    /**
     * 员工身份证号
     */
	@Schema(description = "员工身份证号")
    private String empIdcardNo;

	/**
	 * 项目编码
	 */
	@Schema(description = "项目编码")
    private String deptNo;

	/**
	 * 项目id
	 */
	@Schema(description = "项目id")
	private String deptId;

	/**
	 * 投保岗位
	 */
	@Schema(description = "投保岗位")
	private String post;

    /**
     * 保险公司名称(冗余字段)
     */
	@Schema(description = "保险公司名称")
    private String insuranceCompanyName;

    /**
     * 险种名称
     */
	@Schema(description = "险种名称")
    private String insuranceTypeName;

	/**
	 * 险种主键
	 */
	@Schema(description = "险种主键")
    private Long insuranceTypeId;

    /**
     * 购买标准
     */
	@Schema(description = "购买标准")
    private String buyStandard;

	/**
	 * 费率
	 */
	@Schema(description = "费率")
	private BigDecimal rate;

	/**
	 * 计费方式
	 */
	@Schema(description = "计费方式(0：按天，1：按月)")
	private Integer billingType;

	/**
	 * 医疗额度
	 */
	@Schema(description = "医疗额度")
	private String medicalQuota;

	/**
	 * 身故或残疾额度
	 */
	@Schema(description = "身故或残疾额度")
	private String dieDisableQuota;

    /**
     * 保单编号
     */
	@Schema(description = "保单编号")
    private String policyNo;

    /**
     * 保单开始时间
     */
	@Schema(description = "保单开始时间")
    private LocalDate policyStart;

    /**
     * 保单结束时间
     */
	@Schema(description = "保单结束时间")
    private LocalDate policyEnd;

    /**
     * 保单生效日期
     */
	@Schema(description = "保单生效日期")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
    private LocalDate policyEffect;

    /**
     * 办理时间
     */
	@Schema(description = "办理时间")
    private LocalDateTime batchDate;

	/**
	 * 结算月
	 */
	@Schema(description = "结算月")
	private String settleMonth;

    /**
     * 发票号
     */
	@Schema(description = "发票号")
    private String invoiceNo;

    /**
     * 购买类型， 1新增、3批增、4替换
     */
	@Schema(description = " 购买类型， 1新增、3批增、4替换")
    private Integer buyType;

    /**
     * 商险购买地省code
     */
	@Schema(description = "商险购买地省code")
    private Integer insuranceProvince;

	/**
	 * 商险购买地省
	 */
	@Schema(description = "商险购买地省")
    private String insuranceProvinceName;

    /**
     * 商险购买地市code
     */
	@Schema(description = "商险购买地市code")
    private Integer insuranceCity;

	/**
	 * 商险购买地市
	 */
	@Schema(description = "商险购买地市")
    private String insuranceCityName;

    /**
     * 商险办理省code
     */
	@Schema(description = "商险办理省code")
    private Integer insuranceHandleProvince;

	/**
	 * 商险办理省
	 */
	@Schema(description = "商险办理省")
    private String insuranceHandleProvinceName;

    /**
     * 商险办理城市code
     */
	@Schema(description = "商险办理城市code")
    private Integer insuranceHandleCity;

	/**
	 * 商险办理城市
	 */
	@Schema(description = "商险办理城市")
    private String insuranceHandleCityName;

    /**
     * 结算类型 (0、与薪资合并结算 1、单独结算)
     */
	@Schema(description = "结算类型 (0、与薪资合并结算 1、单独结算)")
    private Integer settleType;

    /**
     * 实际保费
     */
	@Schema(description = "实际保费")
    private BigDecimal actualPremium;

    /**
     * 预估保费
     */
	@Schema(description = "预估保费")
    private BigDecimal estimatePremium;

	/**
	 * 是否标记投保成功标识 0 未标记过 1标记过
	 */
	@Schema(description = "是否标记投保成功标识 0 未标记过 1标记过")
	private Integer signFlag;

    /**
     * 投保办理状态 1待投保 2投保中 3已投保 4投保退回 5 已减员
     */
	@Schema(description = "投保办理状态 1待投保 2投保中 3已投保 4投保退回 5 已减员")
    private Integer buyHandleStatus;

	/**
	 * 默认结算信息id
	 */
	@Schema(description = "默认结算信息id")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private String defaultSettleId;

    /**
     * 减员状态 1待减员 2减员中3减员退回
     */
	@Schema(description = "减员状态 1待减员 2减员中3减员退回,4减员成功")
    private Integer reduceHandleStatus;

    /**
     * 是否出险 0未出险 1已出险
     */
	@Schema(description = "是否出险 0未出险 1已出险")
    private Integer isUse;

    /**
     * 是否有效 0有效 1无效
     */
	@Schema(description = "是否有效 0有效 1无效")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
    private Integer isEffect;

    /**
     * 是否过期 0未过期 1已过期
     */
	@Schema(description = "是否过期 0未过期 1已过期")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
    private Integer isOverdue;

	/**
	 * 备注
	 */
	@Schema(description = "备注")
    private String remark;

    /**
     * 是否删除 0未删除/1删除
     */
	@Schema(description = "是否删除 0否/1是")
    private Integer deleteFlag;

	/**
	 * 商险办理人
	 */
	@Schema(description = "商险办理人")
	private String handledBy;

	/**
	 * 商险办理时间
	 */
	@Schema(description = "商险办理时间")
	private LocalDateTime handledTime;

	/**
	 * 订单编号
	 */
	@Schema(description = "订单编号")
	private String orderNo;

	/**
	 * 收入信息结算状态 0 已结算 1 结算中 2 未结算 3 无需结算
	 */
	@Schema(description = "预估收入信息结算状态")
	private String incomeSettleFlag;

	/**
	 * 收入信息结算状态 0 已收 1 未收 2 垫付
	 */
	@Schema(description = "预估收入信息收款状态")
	private String incomeCollectFlag;

	/**
	 * 支出信息结算状态 0 已结算 1 结算中 2 未结算 3 无需结算
	 */
	@Schema(description = "预估支出信息结算状态")
	private String paySettleFlag;

	/**
	 * 收入信息结算状态 0 已付 1 未付
	 */
	@Schema(description = "预估支出信息付款状态")
	private String payCollectFlag;

	/**
	 * 收入信息结算状态 0 已结算 1 结算中 2 未结算 3 无需结算
	 */
	@Schema(description = "实缴收入信息结算状态")
	private String sincomeSettleFlag;

	/**
	 * 收入信息结算状态 0 已收 1 未收 2 垫付
	 */
	@Schema(description = "实缴收入信息收款状态")
	private String sincomeCollectFlag;

	/**
	 * 支出信息结算状态 0 已结算 1 结算中 2 未结算 3 无需结算
	 */
	@Schema(description = "实缴支出信息结算状态")
	private String spaySettleFlag;

	/**
	 * 收入信息结算状态 0 已付 1 未付
	 */
	@Schema(description = "实缴支出信息付款状态")
	private String spayCollectFlag;

	/**
	 * 创建人所在部门
	 */
	@Schema(description = "创建人所在部门")
	private String createUserDeptId;

	/**
	 * 创建人所在部门名称
	 */
	@Schema(description = "创建人所在部门名称")
	private String createUserDeptName;

	/**
	 * 减员id
	 */
	@Schema(description = "减员id")
	private String refundId;

	/**
	 * EKP的 是否BPO：  是  否
	 */
	@Schema(description = "是否BPO", name = "bpoFlag")
	@ExcelIgnore
	private String bpoFlag;

	@Schema(description = "项目名称")
	private String deptName;

	@Schema(description ="客户id")
	private String unitId;

	@Schema(description ="客户名称")
	private String unitName;

	@Schema(description ="客户编码")
	private String unitNo;

	@Schema(description = "退回原因")
	private String backRemark;

	/**
	 * 忽略提醒 0：忽略 1：不忽略
	 */
	@Schema(description = "有忽略提醒 0：忽略 1：不忽略")
	private String expireIgnoreFlag;

	/**
	 * 消息提醒备注
	 */
	@Schema(description = "消息提醒备注")
	private String expireRemark;

	/**
	 * 是否地市自购0是 1 否
	 */
	@Schema(description = "是否地市自购")
	private String isAdress;

	private static final long serialVersionUID = 1L;
}