package com.yifu.cloud.plus.v1.yifu.insurances.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsurancePolicy;
import com.yifu.cloud.plus.v1.yifu.insurances.service.insurance.TInsurancePolicyService;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.InsurancePolicyListEditParam;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.InsurancePolicyListParam;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.TInsurancePolicyDetailVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.http.HttpHeaders;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.validation.Valid;
import java.util.List;

/**
 * @author licancan
 * @description 保单维护 controller
 * @date 2022-12-07 16:56:53
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/insurancePolicy")
@Tag(name = "保单维护相关")
@SecurityRequirement(name = HttpHeaders.AUTHORIZATION)
public class TInsurancePolicyController {
	@Resource
	private TInsurancePolicyService tInsurancePolicyService;

	/**
	 * 保单号对应起止保时间分页查询
	 *
	 * @author licancan
	 * @param page 分页对象
	 * @param param 查询参数
	 * @return {@link R<IPage<TInsurancePolicy>>}
	 */
	@Operation(summary = "保单号对应起止保时间分页查询", description = "保单号对应起止保时间分页查询")
	@GetMapping("/page" )
	public R<IPage<TInsurancePolicy>> getInsurancePolicyPage(Page page, InsurancePolicyListParam param) {
		return R.ok(tInsurancePolicyService.pageDiy(page, param));
	}

	/**
	 * 保单号对应起止保时间列表（不分页）
	 *
	 * @author licancan
	 * @param param
	 * @return {@link R<List<TInsurancePolicy>>}
	 */
	@Operation(summary = "保单号对应起止保时间列表（不分页）", description = "保单号对应起止保时间（不分页）")
	@GetMapping("/list")
	@PreAuthorize("@pms.hasPermission('insurancePolicy_list')")
	public R<List<TInsurancePolicy>> getInsurancePolicyList(InsurancePolicyListParam param) {
		return R.ok(tInsurancePolicyService.getInsurancePolicyList(param));
	}

	/**
	 * 通过id查询详情
	 *
	 * @author licancan
	 * @param id
	 * @return {@link R<TInsurancePolicyDetailVO>}
	 */
	@GetMapping("/{id}")
	@Operation(summary = "通过id查询详情", description = "通过id查询详情")
	@PreAuthorize("@pms.hasPermission('insurancePolicy_getById')")
	public R<TInsurancePolicyDetailVO> getDetailById(@PathVariable("id" ) String id) {
		return tInsurancePolicyService.getDetailById(id);
	}

	/**
	 * 修改保单号对应起止保时间
	 *
	 * @author licancan
	 * @param param 修改参数
	 * @return {@link R}
	 */
	@Operation(summary = "修改保单号对应起止保时间", description = "修改保单号对应起止保时间)")
	@PostMapping("/update")
	@PreAuthorize("@pms.hasPermission('insurancePolicy_update')")
	public R update(@RequestBody @Valid InsurancePolicyListEditParam param) {
		return tInsurancePolicyService.updateInsurancePolicy(param);
	}

	/**
	 * 删除保单号对应起止保时间
	 *
	 * @author licancan
	 * @param id 主键
	 * @return {@link R}
	 */
	@Operation(summary = "删除保单号对应起止保时间", description = "删除保单号对应起止保时间")
	@DeleteMapping("/{id}" )
	@PreAuthorize("@pms.hasPermission('insurancePolicy_delete')")
	public R deleteById(@PathVariable("id") String id) {
		return tInsurancePolicyService.deleteInsurancePolicy(id);
	}

}
