package com.yifu.cloud.plus.v1.yifu.order.constants;

/**
 * @author licancan
 * @description 订单常量
 * @date 2022-08-29 11:36:21
 */
public class OrderConstants {
	/**
	 * 状态不合法
	 */
	public static final String STATUS_ERROR = "状态不合法";
	/**
	 * 数据不存在
	 */
	public static final String DATA_IS_EMPTY = "数据不存在";
	/**
	 * 订单id不可为空
	 */
	public static final String ORDER_ID_IS_EMPTY = "订单id不可为空";
	/**
	 * 附件id不可为空
	 */
	public static final String ENCLOSURE_ID_IS_EMPTY = "附件id不可为空";
	/**
	 * 订单已办结，不可操作
	 */
	public static final String ORDER_IS_HANDLED= "订单已办结，不可操作";
	/**
	 * 操作成功
	 */
	public static final String OPERATE_SUCCESS = "操作成功";
	/**
	 * 操作失败
	 */
	public static final String OPERATE_FAILED = "操作失败";
	/**
	 * 订单编号不能为空
	 */
	public static final String ORDER_NO_IS_EMPTY = "订单编号不能为空";
	/**
	 * 订单不存在
	 */
	public static final String ORDER_NO_NOT_EXIST = "订单不存在";
	/**
	 * 订单已办结，无法添加回复
	 */
	public static final String ORDER_STATUS_IS_TWO = "订单已办结，无法添加回复";
	/**
	 * 订单已存在
	 */
	public static final String ORDER_NO_IS_EXIST = "订单已存在";
	/**
	 * 下单人不能为空
	 */
	public static final String ORDER_NAME_IS_EMPTY = "下单人不能为空";
	/**
	 * 下单时间不能为空
	 */
	public static final String ORDER_TIME_IS_EMPTY = "下单时间不能为空";
	/**
	 * 项目编码不能为空
	 */
	public static final String DEPT_NO_IS_EMPTY = "项目编码不能为空";
	/**
	 * 项目名称不能为空
	 */
	public static final String DEPT_NAME_IS_EMPTY = "项目名称不能为空";
	/**
	 * 客户名称不能为空
	 */
	public static final String CUSTOMER_NAME_IS_EMPTY = "客户名称不能为空";
	/**
	 * 订单状态不能为空
	 */
	public static final String ORDER_STATUS_IS_EMPTY = "订单状态不能为空";
	/**
	 * 订单内容不能为空
	 */
	public static final String ORDER_CONTENT_IS_EMPTY = "订单内容不能为空";
	/**
	 * 订单内容，2048字以内
	 */
	public static final String ORDER_CONTENT_MORE_THAN_2048 = "订单内容，2048字以内";
	/**
	 * 处理人不能为空
	 */
	public static final String HANDLE_USER_IS_EMPTY = "处理人不能为空";
	/**
	 * 回复人不能为空
	 */
	public static final String REPLY_NAME_IS_EMPTY = "回复人不能为空";
	/**
	 * 回复时间不能为空
	 */
	public static final String REPLY_TIME_IS_EMPTY = "回复时间不能为空";
	/**
	 * 回复内容和附件，两者必填其一
	 */
	public static final String REPLY_CONTENT_AND_ENCLOSURE_IS_EMPTY = "回复内容和附件，两者必填其一";
	/**
	 * “回复内容”，2048字以内
	 */
	public static final String REPLY_CONTENT_MORE_THAN_2048 = "“回复内容”，2048字以内";
	/**
	 * 非法的附件类型
	 */
	public static final String ENCLOSURE_TYPE_IS_ERROR = "非法的附件类型";
	/**
	 * 附件超出上传上限
	 */
	public static final String ENCLOSURE_SIZE_ERROR = "附件超出上传上限";
	/**
	 * 一次性导出不可超过20000条，请分批导出
	 */
	public static final String EXPORT_TOO_LONG = "一次性导出不可超过20000条，请分批导出";
	/**
	 * 订单作废失败
	 */
	public static final String ORDER_INVALID_FAILED = "订单状态为待办理才可作废";


	public static final String ORDER_DEPTMENT_IS_EMPTY = "下单人所在地不能为空";

	public static final String ORDER_CUSTOMER_GRADE_IS_EMPTY = "客户等级不能为空";

	public static final String ORDER_URGENCY_EXTENT_IS_EMPTY = "紧急程度不能为空";

	public static final String ORDER_SERVICE_TYPE_IS_EMPTY = "服务类型不能为空";

	public static final String ORDER_SERVICE_PROJECE_IS_EMPTY = "服务项目不能为空";

	public static final String ORDER_LEVEL_IS_EMPTY = "星级不能为空";

	public static final String ORDER_DEMAND_IS_EMPTY = "其他支撑需求不能为空";

	public static final String ORDER_HANDLE_USER_IS_EMPTY = "指派人不能为空";

	public static final String ORDER_STATUSONE_IS_EMPTY = "待客户确认后提交审核不能为空";
}
