/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryStandardIssue;
import com.yifu.cloud.plus.v1.yifu.salary.service.TSalaryStandardIssueService;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TSalaryStandardIssueSearchVo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;


/**
 * 薪资代发户配置
 *
 * @author hgw
 * @date 2023-01-10 11:34:27
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tsalarystandardissue" )
@Tag(name = "薪资代发户配置管理")
public class TSalaryStandardIssueController {

    private final TSalaryStandardIssueService tSalaryStandardIssueService;

    
    /**
     * 简单分页查询
     * @param page 分页对象
     * @param tSalaryStandardIssue 薪资代发户配置
     * @return
     */
    @Operation(description = "简单分页查询")
    @GetMapping("/page")
    public R<IPage<TSalaryStandardIssue>> getTSalaryStandardIssuePage(Page<TSalaryStandardIssue> page, TSalaryStandardIssueSearchVo tSalaryStandardIssue) {
        return  new R<>(tSalaryStandardIssueService.getTSalaryStandardIssuePage(page,tSalaryStandardIssue));
    }
    /**
     * 不分页查询
     * @param tSalaryStandardIssue 薪资代发户配置
     * @return
     */
    @Operation(summary = "不分页查询", description = "不分页查询")
    @PostMapping("/noPage" )
    //@PreAuthorize("@pms.hasPermission('tsalarystandardissue_get')" )
    public R<List<TSalaryStandardIssue>> getTSalaryStandardIssueNoPage(@RequestBody TSalaryStandardIssueSearchVo tSalaryStandardIssue) {
        return R.ok(tSalaryStandardIssueService.noPageDiy(tSalaryStandardIssue));
    }

    /**
     * 通过id查询薪资代发户配置
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id查询", description = "通过id查询：hasPermission('tsalarystandardissue_get')")
    @GetMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('tsalarystandardissue_get')" )
    public R<TSalaryStandardIssue> getById(@PathVariable("id" ) String id) {
        return R.ok(tSalaryStandardIssueService.getById(id));
    }

    /**
     * 新增薪资代发户配置
     * @param tSalaryStandardIssue 薪资代发户配置
     * @return R
     */
    @Operation(summary = "新增薪资代发户配置", description = "新增薪资代发户配置：hasPermission('tsalarystandardissue_add')")
    @SysLog("新增薪资代发户配置" )
    @PostMapping
    @PreAuthorize("@pms.hasPermission('tsalarystandardissue_add')" )
    public R<Boolean> save(@RequestBody TSalaryStandardIssue tSalaryStandardIssue) {
        return R.ok(tSalaryStandardIssueService.save(tSalaryStandardIssue));
    }

    /**
     * 修改薪资代发户配置
     * @param tSalaryStandardIssue 薪资代发户配置
     * @return R
     */
    @Operation(summary = "修改薪资代发户配置", description = "修改薪资代发户配置：hasPermission('tsalarystandardissue_edit')")
    @SysLog("修改薪资代发户配置" )
    @PutMapping
    @PreAuthorize("@pms.hasPermission('tsalarystandardissue_edit')" )
    public R<Boolean> updateById(@RequestBody TSalaryStandardIssue tSalaryStandardIssue) {
        return R.ok(tSalaryStandardIssueService.updateById(tSalaryStandardIssue));
    }

    /**
     * 通过id删除薪资代发户配置
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id删除薪资代发户配置", description = "通过id删除薪资代发户配置：hasPermission('tsalarystandardissue_del')")
    @SysLog("通过id删除薪资代发户配置" )
    @DeleteMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('tsalarystandardissue_del')" )
    public R<Boolean> removeById(@PathVariable String id) {
        return R.ok(tSalaryStandardIssueService.removeById(id));
    }

    /**
     * 薪资代发户配置 批量导出
     * @author hgw
     * @date 2023-01-10 11:34:27
     **/
    @Operation(description = "导出薪资代发户配置 hasPermission('tsalarystandardissue-export')")
    @PostMapping("/export")
    @PreAuthorize("@pms.hasPermission('tsalarystandardissue-export')")
    public void export(HttpServletResponse response, @RequestBody TSalaryStandardIssueSearchVo searchVo) {
            tSalaryStandardIssueService.listExport(response,searchVo);
    }
}
