package com.yifu.cloud.plus.v1.yifu.salary.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TInsuranceUnpurchasePersonSalary;
import com.yifu.cloud.plus.v1.yifu.salary.mapper.TInsuranceUnpurchasePersonSalaryMapper;
import com.yifu.cloud.plus.v1.yifu.salary.service.TInsuranceUnpurchasePersonSalaryService;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 含风险项目不购买申请明细表
 *
 * @author huych
 * @date 2025-01-10 11:23:21
 */
@Log4j2
@Service
public class TInsuranceUnpurchasePersonSalaryServiceImpl extends ServiceImpl<TInsuranceUnpurchasePersonSalaryMapper
		, TInsuranceUnpurchasePersonSalary> implements TInsuranceUnpurchasePersonSalaryService {
	/**
	 * 含风险项目不购买申请明细表简单分页查询-薪资关联
	 *
	 * @param tInsuranceUnpurchasePerson 含风险项目不购买申请明细表-薪资关联
	 * @return
	 */
	@Override
	public IPage<TInsuranceUnpurchasePersonSalary> getTInsuranceUnpurchasePersonSalaryPage(Page<TInsuranceUnpurchasePersonSalary> page, TInsuranceUnpurchasePersonSalary tInsuranceUnpurchasePerson) {
		return baseMapper.getTInsuranceUnpurchasePersonSalaryPage(page, tInsuranceUnpurchasePerson);
	}

	/**
	 * @param salaryId
	 * @Description: 删除薪资后，清除关联项与次数
	 * @Author: hgw
	 * @Date: 2025/1/15 13:04
	 * @return: void
	 **/
	@Override
	public void deletePersonSalaryBySalaryId(String salaryId) {
		List<String> parentIds = baseMapper.getParentIdBySalaryId(salaryId);
		// 后刷新次数
		if (parentIds != null && !parentIds.isEmpty()) {
			// 先删除
			baseMapper.deletePersonSalaryBySalaryId(salaryId);
			baseMapper.updatePersonSalaryNumByPersonIdList(parentIds);
		}
	}

	@Override
	public void updatePersonSalaryNumByParentIds(List<String> parentIds) {
		// 刷新次数
		baseMapper.updatePersonSalaryNumByPersonIdList(parentIds);
	}

}
