/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;
import java.util.List;
import java.util.Set;

/**
 * 预估费用
 *
 * @author hgw
 * @date 2022-07-18 16:21:40
 */
@Data
@TableName("t_forecast_library")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "预估费用")
public class TForecastLibrary extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("主键")
	private String id;
	/**
	 * 人员档案id
	 */
	@ExcelAttribute(name = "人员档案id", maxLength = 32)
	@Length(max = 32, message = "人员档案id不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("人员档案id")
	private String empId;
	/**
	 * 员工编码
	 */
	@ExcelAttribute(name = "员工编码", maxLength = 32)
	@Length(max = 32, message = "员工编码不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工编码")
	private String empNo;
	/**
	 * 员工姓名
	 */
	@ExcelAttribute(name = "员工姓名", maxLength = 32)
	@Length(max = 32, message = "员工姓名不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工姓名")
	private String empName;
	/**
	 * 身份证号
	 */
	@ExcelAttribute(name = "身份证号", maxLength = 20)
	@Length(max = 20, message = "身份证号不能超过20个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证号")
	private String empIdcard;
	/**
	 * 社保ID
	 */
	@ExcelAttribute(name = "社保ID", maxLength = 32)
	@Length(max = 32, message = "社保ID不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保ID")
	private String socialId;
	/**
	 * 部门ID
	 */
	@ExcelAttribute(name = "部门ID", isNotEmpty = true, errorInfo = "部门ID不能为空", maxLength = 32)
	@NotBlank(message = "部门ID不能为空")
	@Length(max = 32, message = "部门ID不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("部门ID")
	private String settleDomainId;
	/**
	 * 单位ID
	 */
	@ExcelAttribute(name = "单位ID", maxLength = 32)
	@Length(max = 32, message = "单位ID不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位ID")
	private String unitId;
	/**
	 * 公积金ID
	 */
	@ExcelAttribute(name = "公积金ID", maxLength = 32)
	@Length(max = 32, message = "公积金ID不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金ID")
	private String providentId;
	/**
	 * 单位养老费用
	 */
	@ExcelAttribute(name = "单位养老费用")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位养老费用")
	private BigDecimal unitPensionFee;
	/**
	 * 单位医疗费用
	 */
	@ExcelAttribute(name = "单位医疗费用")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位医疗费用")
	private BigDecimal unitMedicalFee;
	/**
	 * 单位失业费用
	 */
	@ExcelAttribute(name = "单位失业费用")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位失业费用")
	private BigDecimal unitUnemploymentFee;
	/**
	 * 单位工伤费用
	 */
	@ExcelAttribute(name = "单位工伤费用")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位工伤费用")
	private BigDecimal unitWorkInjuryFee;
	/**
	 * 单位生育费用
	 */
	@ExcelAttribute(name = "单位生育费用")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位生育费用")
	private BigDecimal unitBirthFee;
	/**
	 * 单位医疗救助金-单位大病金额
	 */
	@ExcelAttribute(name = "单位医疗救助金")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位医疗救助金")
	private BigDecimal unitBitailmentFee;
	/**
	 * 个人养老费用
	 */
	@ExcelAttribute(name = "个人养老费用")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人养老费用")
	private BigDecimal personalPensionFee;
	/**
	 * 个人医疗费用
	 */
	@ExcelAttribute(name = "个人医疗费用")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人医疗费用")
	private BigDecimal personalMedicalFee;
	/**
	 * 个人失业费用
	 */
	@ExcelAttribute(name = "个人失业费用")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人失业费用")
	private BigDecimal personalUnemploymentFee;
	/**
	 * 个人医疗救助金-个人大病金额
	 */
	@ExcelAttribute(name = "个人医疗救助金")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人医疗救助金")
	private BigDecimal personalBigailmentFee;
	/**
	 * 社保缴纳月份
	 */
	@ExcelAttribute(name = "社保缴纳月份", maxLength = 6)
	@Length(max = 6, message = "社保缴纳月份不能超过6个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保缴纳月份")
	private String socialPayMonth;
	/**
	 * 社保生成月份
	 */
	@ExcelAttribute(name = "社保生成月份", maxLength = 6)
	@Length(max = 6, message = "社保生成月份不能超过6个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保生成月份")
	private String socialCreateMonth;
	/**
	 * 公积金缴纳月份
	 */
	@ExcelAttribute(name = "公积金缴纳月份", maxLength = 6)
	@Length(max = 6, message = "公积金缴纳月份不能超过6个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金缴纳月份")
	private String providentPayMonth;
	/**
	 * 公积金生成月份
	 */
	@ExcelAttribute(name = "公积金生成月份", maxLength = 6)
	@Length(max = 6, message = "公积金生成月份不能超过6个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金生成月份")
	private String providentCreateMonth;
	/**
	 * 单位社保合计
	 */
	@ExcelAttribute(name = "单位社保合计")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位社保合计")
	private BigDecimal unitSocialSum;
	/**
	 * 单位公积金合计
	 */
	@ExcelAttribute(name = "单位公积金合计")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位公积金合计")
	private BigDecimal unitFundSum;
	/**
	 * 个人社保合计
	 */
	@ExcelAttribute(name = "个人社保合计")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人社保合计")
	private BigDecimal personalSocialSum;
	/**
	 * 个人公积金合计
	 */
	@ExcelAttribute(name = "个人公积金合计")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人公积金合计")
	private BigDecimal personalFundSum;
	/**
	 * 费用合计
	 */
	@ExcelAttribute(name = "费用合计")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("费用合计")
	private BigDecimal sumAll;
	/**
	 * 公积金缴纳地-省
	 */
	@ExcelAttribute(name = "公积金缴纳地-省", maxLength = 32)
	@Length(max = 32, message = "公积金缴纳地-省不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金缴纳地-省")
	private String fundProvince;
	/**
	 * 缴纳地-市
	 */
	@ExcelAttribute(name = "公积金缴纳地-市", maxLength = 32)
	@Length(max = 32, message = "公积金缴纳地-市不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金缴纳地-市")
	private String fundCity;
	/**
	 * 公积金缴纳地-县
	 */
	@ExcelAttribute(name = "公积金缴纳地-县", maxLength = 32)
	@Length(max = 32, message = "公积金缴纳地-县不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金缴纳地-县")
	private String fundTown;
	/**
	 * 社保缴纳地-省
	 */
	@ExcelAttribute(name = "社保缴纳地-省", maxLength = 32)
	@Length(max = 32, message = "社保缴纳地-省不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保缴纳地-省")
	private String socialProvince;
	/**
	 * 社保缴纳地-市
	 */
	@ExcelAttribute(name = "社保缴纳地-市", maxLength = 32)
	@Length(max = 32, message = "社保缴纳地-市不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保缴纳地-市")
	private String socialCity;
	/**
	 * 社保缴纳地-县
	 */
	@ExcelAttribute(name = "社保缴纳地-县", maxLength = 32)
	@Length(max = 32, message = "社保缴纳地-县不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保缴纳地-县")
	private String socialTown;
	/**
	 * 单位养老基数
	 */
	@ExcelAttribute(name = "单位养老基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位养老基数")
	private BigDecimal unitPensionBase;
	/**
	 * 单位医疗基数
	 */
	@ExcelAttribute(name = "单位医疗基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位医疗基数")
	private BigDecimal unitMedicalBase;
	/**
	 * 单位失业基数
	 */
	@ExcelAttribute(name = "单位失业基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位失业基数")
	private BigDecimal unitUnemploymentBase;
	/**
	 * 单位工伤基数
	 */
	@ExcelAttribute(name = "单位工伤基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位工伤基数")
	private BigDecimal unitInjuryBase;
	/**
	 * 单位生育基数
	 */
	@ExcelAttribute(name = "单位生育基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位生育基数")
	private BigDecimal unitBirthBase;
	/**
	 * 单位大病基数
	 */
	@ExcelAttribute(name = "单位大病基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位大病基数")
	private BigDecimal unitBigailmentBase;
	/**
	 * 个人养老基数
	 */
	@ExcelAttribute(name = "个人养老基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人养老基数")
	private BigDecimal personalPensionBase;
	/**
	 * 个人医疗基数
	 */
	@ExcelAttribute(name = "个人医疗基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人医疗基数")
	private BigDecimal personalMedicalBase;
	/**
	 * 个人失业基数
	 */
	@ExcelAttribute(name = "个人失业基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人失业基数")
	private BigDecimal personalUnemploymentBase;
	/**
	 * 个人大病基数
	 */
	@ExcelAttribute(name = "个人大病基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人大病基数")
	private BigDecimal personalBigailmentBase;
	/**
	 * 单位养老比例
	 */
	@ExcelAttribute(name = "单位养老比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位养老比例")
	private BigDecimal unitPersionPro;
	/**
	 * 单位医疗比例
	 */
	@ExcelAttribute(name = "单位医疗比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位医疗比例")
	private BigDecimal unitMedicalPro;
	/**
	 * 单位失业比例
	 */
	@ExcelAttribute(name = "单位失业比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位失业比例")
	private BigDecimal unitUnemploymentPro;
	/**
	 * 单位工伤比例
	 */
	@ExcelAttribute(name = "单位工伤比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位工伤比例")
	private BigDecimal unitInjuryPro;
	/**
	 * 单位生育比例
	 */
	@ExcelAttribute(name = "单位生育比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位生育比例")
	private BigDecimal unitBirthPro;
	/**
	 * 单位大病比例
	 */
	@ExcelAttribute(name = "单位大病比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位大病比例")
	private BigDecimal unitBigailmentPro;
	/**
	 * 个人养老比例
	 */
	@ExcelAttribute(name = "个人养老比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人养老比例")
	private BigDecimal personalPersionPro;
	/**
	 * 个人医疗比例
	 */
	@ExcelAttribute(name = "个人医疗比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人医疗比例")
	private BigDecimal personalMedicalPro;
	/**
	 * 个人失业比例
	 */
	@ExcelAttribute(name = "个人失业比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人失业比例")
	private BigDecimal personalUnemploymentPro;
	/**
	 * 个人大病比例
	 */
	@ExcelAttribute(name = "个人大病比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人大病比例")
	private BigDecimal personalBigailmentPro;
	/**
	 * 单位公积金基数
	 */
	@ExcelAttribute(name = "单位公积金基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位公积金基数")
	private BigDecimal unitFundBase;
	/**
	 * 个人公积金基数
	 */
	@ExcelAttribute(name = "个人公积金基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人公积金基数")
	private BigDecimal personalFundBase;
	/**
	 * 单位公积金比例
	 */
	@ExcelAttribute(name = "单位公积金比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位公积金比例")
	private BigDecimal unitFundProp;
	/**
	 * 个人公积金比例
	 */
	@ExcelAttribute(name = "个人公积金比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人公积金比例")
	private BigDecimal personalFundProp;
	/**
	 * 备注
	 */
	@ExcelAttribute(name = "备注", maxLength = 32)
	@Length(max = 32, message = "备注不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("备注")
	private String remark;
	/**
	 * 项目档案id
	 */
	@ExcelAttribute(name = "项目档案id", maxLength = 32)
	@Length(max = 32, message = "项目档案id不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目档案id")
	private String projectId;
	/**
	 * 客户名称
	 */
	@ExcelAttribute(name = "客户名称", maxLength = 50)
	@Length(max = 50, message = "客户名称不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("客户名称")
	private String unitName;
	/**
	 * 项目名称
	 */
	@ExcelAttribute(name = "项目名称", maxLength = 50)
	@Length(max = 50, message = "项目名称不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目名称")
	private String deptName;
	/**
	 * 项目编码
	 */
	@ExcelAttribute(name = "项目编码", maxLength = 50)
	@Length(max = 50, message = "项目编码不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目编码")
	private String deptNo;
	/**
	 * 员工类型（字典值，0外包1派遣2代理）
	 */
	@ExcelAttribute(name = "员工类型（字典值，0外包1派遣2代理3内部员工）", maxLength = 1)
	@Length(max = 1, message = "员工类型（字典值，0外包1派遣2代理3内部员工）不能超过1个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工类型（字典值，0外包1派遣2代理3内部员工）")
	private String empNatrue;
	/**
	 * 单位补缴利息
	 */
	@ExcelAttribute(name = "单位补缴利息")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位补缴利息")
	private BigDecimal unitInterestFee;
	/**
	 * 个人补缴利息
	 */
	@ExcelAttribute(name = "个人补缴利息")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人补缴利息")
	private BigDecimal personalInterestFee;
	/**
	 * 社保户id
	 */
	@ExcelAttribute(name = "社保户id", maxLength = 32)
	@Length(max = 32, message = "社保户id不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保户id")
	private String socialHousehold;
	/**
	 * 社保户
	 */
	@ExcelAttribute(name = "社保户", maxLength = 50)
	@Length(max = 50, message = "社保户不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保户")
	private String socialHouseholdName;
	/**
	 * 公积金户id
	 */
	@ExcelAttribute(name = "公积金户id", maxLength = 32)
	@Length(max = 32, message = "公积金户id不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金户id")
	private String providentHousehold;
	/**
	 * 公积金户
	 */
	@ExcelAttribute(name = "公积金户", maxLength = 50)
	@Length(max = 50, message = "公积金户不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金户")
	private String providentHouseholdName;
	/**
	 * 同步状态：0未同步；1已同步
	 */
	@ExcelAttribute(name = "同步状态：0未同步；1已同步")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("同步状态：0未同步；1已同步")
	private Integer dataPush;
	/**
	 * 类型：0社保；1公积金
	 */
	@ExcelAttribute(name = "类型：0社保；1公积金")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("类型：0社保；1公积金")
	private Integer dataType;
	/**
	 * 数据类型：预估/差额（汉字）
	 */
	@ExcelAttribute(name = "数据类型：预估/差额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("数据类型：预估/差额")
	private String diffType;

	/**
	 * 工资社保结算状态  0: 未结算  1: 待结算  2: 已结算
	 */
	@ExcelAttribute(name = "工资社保结算状态", maxLength = 1,isDataId = true,dataType = "settlement_flag")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("工资社保结算状态")
	private String salarySocialFlag;
	/**
	 * 工资公积金结算状态  0: 未结算  1: 待结算  2: 已结算
	 */
	@ExcelAttribute(name = "工资公积金结算状态", maxLength = 1,isDataId = true,dataType = "settlement_flag")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("工资公积金结算状态")
	private String salaryFundFlag;

	/**
	 * 收入信息结算状态 0 已结算 1 结算中 2 未结算 3 已冻结
	 */
	@ExcelAttribute(name = "收入信息结算状态", maxLength = 2)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("收入信息结算状态")
	private String incomeSettleFlag;

	/**
	 * 收入信息结算状态 0 已收 1 未收 2 垫付
	 */
	@ExcelAttribute(name = "收入信息收款状态", maxLength = 2)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("收入信息收款状态")
	private String incomeCollectFlag;

	/**
	 * 支出信息结算状态 0 已结算 1 结算中 2 未结算
	 */
	@ExcelAttribute(name = "支出信息结算状态", maxLength = 2)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("支出信息结算状态")
	private String paySettleFlag;

	/**
	 * 支出信息付款状态 0 已付 1 未付
	 */
	@ExcelAttribute(name = "支出信息付款状态", maxLength = 2)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("支出信息付款状态")
	private String payCollectFlag;

	@TableField(exist = false)
	private List<String> idList;

	@Schema(description = "数据生成时间起")
	@TableField(exist = false)
	private String createTimeStart;

	@Schema(description = "数据生成时间止")
	@TableField(exist = false)
	private String createTimeEnd;

	@TableField(exist = false)
	@Schema(description = "导出的表头的Set")
	private Set<String> exportFields;
	/**
	 * 查询数据起
	 **/
	@Schema(description = "查询limit  开始")
	@TableField(exist = false)
	private int limitStart;
	/**
	 * 查询数据止
	 **/
	@Schema(description = "查询limit  数据条数")
	@TableField(exist = false)
	private int limitEnd;

}
