/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.*;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.util.Date;

/**
 * 社保医疗截止日配置
 *
 * @author fxj
 * @date 2024-05-08 11:52:09
 */
@Data
@TableName("t_social_deadline_info")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "社保医疗截止日配置")
public class TSocialDeadlineInfo extends BaseEntity {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("id")
	@Schema(description = "id")
	private String id;
	/**
	 * 月份
	 */
	@ExcelAttribute(name = "月份", isNotEmpty = true, errorInfo = "月份不能为空", maxLength = 6)
	@NotBlank(message = "月份不能为空")
	@Length(max = 6, message = "月份不能超过6个字符")
	@ExcelProperty("月份")
	@Schema(description = "月份")
	private Integer month;
	/**
	 * 省
	 */
	@ExcelAttribute(name = "省", isNotEmpty = true, errorInfo = "省不能为空", maxLength = 10,isArea = true)
	@NotBlank(message = "省不能为空")
	@Length(max = 10, message = "省不能超过10个字符")
	@ExcelProperty("省")
	@Schema(description = "省")
	private String province;
	/**
	 * 市
	 */
	@ExcelAttribute(name = "市", maxLength = 10,isArea = true, parentField = "province")
	@Length(max = 10, message = "市不能超过10个字符")
	@ExcelProperty("市")
	@Schema(description = "市")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private String city;
	/**
	 * 县
	 */
	@ExcelAttribute(name = "县", maxLength = 10,isArea = true, parentField = "city")
	@Length(max = 10, message = "县不能超过10个字符")
	@ExcelProperty("县")
	@Schema(description = "县")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private String town;
	/**
	 * 社保（增员）起始日
	 */
	@ExcelAttribute(name = "社保起始日", isNotEmpty = true, errorInfo = "社保起始日不能为空", isDate = true)
	@NotBlank(message = "社保起始日不能为空")
	@ExcelProperty("社保起始日")
	@Schema(description = "社保起始日")
	private Date socialStartDate;
	/**
	 * 社保（增员）截止日
	 */
	@ExcelAttribute(name = "社保截止日", isNotEmpty = true, errorInfo = "社保截止日不能为空", isDate = true)
	@NotBlank(message = "社保截止日不能为空")
	@ExcelProperty("社保截止日")
	@Schema(description = "社保截止日")
	private Date socialEndDate;
	/**
	 * 医疗（增员）起始日
	 */
	@ExcelAttribute(name = "医疗起始日", isNotEmpty = true, errorInfo = "医疗起始日不能为空", isDate = true)
	@NotBlank(message = "医疗起始日不能为空")
	@ExcelProperty("医疗起始日")
	@Schema(description = "医疗起始日")
	private Date medicalStartDate;
	/**
	 * 医疗（增员）截止日
	 */
	@ExcelAttribute(name = "医疗截止日", isNotEmpty = true, errorInfo = "医疗截止日不能为空", isDate = true)
	@NotBlank(message = "医疗截止日不能为空")
	@ExcelProperty("医疗截止日")
	@Schema(description = "医疗截止日")
	private Date medicalEndDate;
	/**
	 * 更新人
	 */
	@ExcelAttribute(name = "更新人", maxLength = 32)
	@Length(max = 32, message = "更新人不能超过32个字符")
	@ExcelProperty("更新人")
	@Schema(description = "更新人")
	private String updateName;
	/**
	 * 启用禁用：0启用  1 禁用
	 */
	@ExcelAttribute(name = "启用禁用：0启用  1 禁用", maxLength = 1)
	@Length(max = 1, message = "启用禁用：0启用  1 禁用不能超过1个字符")
	@ExcelProperty("启用禁用：0启用  1 禁用")
	@Schema(description = "启用禁用：0启用  1 禁用")
	private String status;


	/**
	 * 配置类型：0 非基础配置 1基础配置(后面配置都是按他生成的)
	 */
	@Length(max = 1, message = "配置类型：0 非基础配置 1基础配置(后面配置都是按他生成的)  禁用不能超过1个字符")
	@Schema(description = "配置类型：0 非基础配置 1基础配置(后面配置都是按他生成的)")
	private String type;


	/**
	 * 社保减员起始日期
	 */
	@ExcelAttribute(name = "社保减员起始日期", isNotEmpty = true, errorInfo = "社保减员起始日期不能为空", isDate = true)
	@NotBlank(message = "社保减员起始日期不可为空")
	@ExcelProperty("社保减员起始日期")
	@Schema(description = "社保减员起始日期")
	private Date socialStartDateReduce;

	/**
	 * 医疗减员起始日期
	 */
	@ExcelAttribute(name = "医疗减员起始日期", isNotEmpty = true, errorInfo = "医疗减员起始日期不能为空", isDate = true)
	@NotBlank(message = "医疗减员起始日期不能为空")
	@ExcelProperty("医疗减员起始日期")
	@Schema(description = "医疗减员起始日期")
	private Date medicalStartDateReduce;

	/**
	 * 社保减员截止日期
	 */
	@ExcelAttribute(name = "社保减员截止日期", isNotEmpty = true, errorInfo = "社保减员截止日期不能为空", isDate = true)
	@NotBlank(message = "社保减员截止日期不能为空")
	@ExcelProperty("社保减员截止日期")
	@Schema(description = "社保减员截止日期")
	private Date socialEndDateReduce;

	/**
	 * 医疗减员截止日期
	 */
	@ExcelAttribute(name = "医疗减员截止日期", isNotEmpty = true, errorInfo = "医疗减员截止日期不能为空", isDate = true)
	@NotBlank(message = "医疗减员截止日期不能为空")
	@ExcelProperty("医疗减员截止日期")
	@Schema(description = "医疗减员截止日期")
	private Date medicalEndDateReduce;

}
