/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TAutoSocialRuleRel;
import com.yifu.cloud.plus.v1.yifu.archives.service.TAutoSocialRuleRelService;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TAutoSocialRuleRelVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TAutoSocialRuleRelSearchVo;
import lombok.SneakyThrows;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.http.HttpHeaders;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;


/**
 * 社保购买规则明细表
 *
 * @author fxj
 * @date 2025-10-09 11:13:18
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tautosocialrulerel")
@Tag(name = "社保购买规则明细表管理")
public class TAutoSocialRuleRelController {

	private final TAutoSocialRuleRelService tAutoSocialRuleRelService;


	/**
	 * 简单分页查询
	 *
	 * @param page               分页对象
	 * @param tAutoSocialRuleRel 社保购买规则明细表
	 * @return
	 */
	@Operation(description = "简单分页查询")
	@GetMapping("/page")
	public R<IPage<TAutoSocialRuleRel>> getTAutoSocialRuleRelPage(Page<TAutoSocialRuleRel> page, TAutoSocialRuleRelSearchVo tAutoSocialRuleRel) {
		return new R<>(tAutoSocialRuleRelService.getTAutoSocialRuleRelPage(page, tAutoSocialRuleRel));
	}

	/**
	 * 不分页查询
	 *
	 * @param tAutoSocialRuleRel 社保购买规则明细表
	 * @return
	 */
	@Operation(summary = "不分页查询", description = "不分页查询")
	@PostMapping("/noPage")
	//@PreAuthorize("@pms.hasPermission('archives_tautosocialrulerel_get')" )
	public R<List<TAutoSocialRuleRel>> getTAutoSocialRuleRelNoPage(@RequestBody TAutoSocialRuleRelSearchVo tAutoSocialRuleRel) {
		return R.ok(tAutoSocialRuleRelService.noPageDiy(tAutoSocialRuleRel));
	}

	/**
	 * 通过id查询社保购买规则明细表
	 *
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id查询", description = "通过id查询：hasPermission('archives_tautosocialrulerel_get')")
	@GetMapping("/{id}")
	@PreAuthorize("@pms.hasPermission('archives_tautosocialrulerel_get')")
	public R<TAutoSocialRuleRel> getById(@PathVariable("id") String id) {
		return R.ok(tAutoSocialRuleRelService.getById(id));
	}

	/**
	 * 新增社保购买规则明细表
	 *
	 * @param tAutoSocialRuleRel 社保购买规则明细表
	 * @return R
	 */
	@Operation(summary = "新增社保购买规则明细表", description = "新增社保购买规则明细表：hasPermission('archives_tautosocialrulerel_add')")
	@SysLog("新增社保购买规则明细表")
	@PostMapping
	@PreAuthorize("@pms.hasPermission('archives_tautosocialrulerel_add')")
	public R<Boolean> save(@RequestBody TAutoSocialRuleRel tAutoSocialRuleRel) {
		return R.ok(tAutoSocialRuleRelService.save(tAutoSocialRuleRel));
	}

	/**
	 * 修改社保购买规则明细表
	 *
	 * @param tAutoSocialRuleRel 社保购买规则明细表
	 * @return R
	 */
	@Operation(summary = "修改社保购买规则明细表", description = "修改社保购买规则明细表：hasPermission('archives_tautosocialrulerel_edit')")
	@SysLog("修改社保购买规则明细表")
	@PutMapping
	@PreAuthorize("@pms.hasPermission('archives_tautosocialrulerel_edit')")
	public R<Boolean> updateById(@RequestBody TAutoSocialRuleRel tAutoSocialRuleRel) {
		return R.ok(tAutoSocialRuleRelService.updateById(tAutoSocialRuleRel));
	}

	/**
	 * 通过id删除社保购买规则明细表
	 *
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id删除社保购买规则明细表", description = "通过id删除社保购买规则明细表：hasPermission('archives_tautosocialrulerel_del')")
	@SysLog("通过id删除社保购买规则明细表")
	@DeleteMapping("/{id}")
	@PreAuthorize("@pms.hasPermission('archives_tautosocialrulerel_del')")
	public R<Boolean> removeById(@PathVariable String id) {
		return R.ok(tAutoSocialRuleRelService.removeById(id));
	}

	/**
	 * 社保购买规则明细表 批量导入
	 *
	 * @author fxj
	 * @date 2025-10-09 11:13:18
	 **/
	@SneakyThrows
	@Operation(description = "批量新增社保购买规则明细表 hasPermission('archives_tautosocialrulerel-batch-import')")
	@SysLog("批量新增社保购买规则明细表")
	@PostMapping("/importListAdd")
	@PreAuthorize("@pms.hasPermission('archives_tautosocialrulerel-batch-import')")
	public R<List<ErrorMessage>> importListAdd(@RequestBody MultipartFile file) {
		return tAutoSocialRuleRelService.importDiy(file.getInputStream());
	}

	/**
	 * 社保购买规则明细表 批量导出
	 *
	 * @author fxj
	 * @date 2025-10-09 11:13:18
	 **/
	@Operation(description = "导出社保购买规则明细表 hasPermission('archives_tautosocialrulerel-export')")
	@PostMapping("/export")
	@PreAuthorize("@pms.hasPermission('archives_tautosocialrulerel-export')")
	public void export(HttpServletResponse response, @RequestBody TAutoSocialRuleRelSearchVo searchVo) {
		tAutoSocialRuleRelService.listExport(response, searchVo);
	}
}
