/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TAutoSocialRuleRel;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TAutoSocialRuleRelSearchVo;
import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.util.List;

/**
 * 社保购买规则明细表
 *
 * @author fxj
 * @date 2025-10-09 11:13:18
 */
public interface TAutoSocialRuleRelService extends IService<TAutoSocialRuleRel> {
    /**
     * 社保购买规则明细表简单分页查询
     * @param tAutoSocialRuleRel 社保购买规则明细表
     * @return
     */
    IPage<TAutoSocialRuleRel> getTAutoSocialRuleRelPage(Page<TAutoSocialRuleRel> page, TAutoSocialRuleRelSearchVo tAutoSocialRuleRel);

    R<List<ErrorMessage>> importDiy(InputStream inputStream);

    void listExport(HttpServletResponse response, TAutoSocialRuleRelSearchVo searchVo);

    List<TAutoSocialRuleRel> noPageDiy(TAutoSocialRuleRelSearchVo searchVo);
}
