package com.yifu.cloud.plus.v1.ekp.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 社保明细表
 *
 * @author huyc
 * @date 2024-02-29 11:21:56
 */
@Data
@TableName("ekp_social_info")
@EqualsAndHashCode()
@Schema(description = "社保明细表")
public class EkpSocialInfo {

	@TableId(type = IdType.ASSIGN_ID)
	private String fd_id;

	@Schema(description ="订单类型")
	private String fd_3add9dd7833db8;

	@Schema(description ="是否有预估")
	private String fd_3add9de0be85e4;

	@Schema(description ="与工资合并结算")
	private String fd_3add9e1a670144;

	@Schema(description ="项目编码")
	private String fd_3adfe8c70d3fd4;

	@Schema(description ="项目名称")
	private String fd_3adfe8c8468e54;

	/**
	 * 项目编码-原
	 **/
	private String fd_3cfe2da7e35daa;
	/**
	 * 项目名称-原
	 **/
	private String fd_3cfe2db5015d6e;

	@Schema(description ="单号")
	private String fd_3adfe95c169c48;

	@Schema(description ="客户编码")
	private String fd_3adfe8c73cb5a4;

	@Schema(description ="客户名称")
	private String fd_3adfe8c81a0e42;

	@Schema(description ="姓名")
	private String fd_3adfe8c79989d4;

	@Schema(description ="身份证号")
	private String fd_3adfe8c7e4cf7a;

	@Schema(description ="生成月份")
	private String fd_3adfe8cb96c41e;

	@Schema(description ="缴纳月份")
	private String fd_3adfe8cf632700;

	@Schema(description ="实际结算月份")
	private String fd_3adfe8cff746bc;

	@Schema(description ="预估单位部分")
	private Double fd_3adfeb4e8064a8;

	@Schema(description ="实缴个人部分")
	private Double fd_3adfeb5366dd82;

	@Schema(description ="单位差异")
	private Double fd_3adfeb53c70f72;

	@Schema(description ="个人差异")
	private Double fd_3adfeb5413fb44;

	@Schema(description ="应收")
	private Double fd_3adfeb7b624f06;

	@Schema(description ="结算状态")
	private String fd_3add9ea428879a;

	@Schema(description ="收款状态")
	private String fd_3add9eaeed2560;

	@Schema(description ="结算单号")
	private String fd_3adfeb830523b6;

	@Schema(description ="收款单号")
	private String fd_3adfeb8489e6c2;

	@Schema(description ="应支出")
	private Double fd_3adfeb7bd97464;

	@Schema(description ="支出结算状态")
	private String fd_3add9edfbc6f7e;

	@Schema(description ="付款状态")
	private String fd_3add9eed23894a;
	
	@Schema(description ="支出缴纳单号")
	private String fd_3adfeb83a704c8;
	
	@Schema(description ="付款单号")
	private String fd_3adfeb84175f28;
	
	@Schema(description ="社保户")
	private String fd_3aeafa25916e82;
	
	@Schema(description ="实缴个人失业")
	private Double fd_3af9f2fa79ee72;
	
	@Schema(description ="实缴个人养老")
	private Double fd_3af9f2ec516c30;
	
	@Schema(description ="实缴个人补缴利息")
	private Double fd_3af9f2fcde9158;
	
	@Schema(description ="预估个人合计")
	private Double fd_3af9f285ee1e38;
	
	@Schema(description ="实缴单位失业")
	private Double fd_3af9f2dd5d8fb8;
	
	@Schema(description ="实缴单位工伤")
	private Double fd_3af9f2e03295dc;
	
	@Schema(description ="预估个人养老")
	private Double fd_3af9f27a3974e6;
	
	@Schema(description ="预估单位医疗")
	private Double fd_3af9f25b851e94;
	
	@Schema(description ="实缴合计")
	private Double fd_3af9f3059e5b9c;
	
	@Schema(description ="预估单位大病救助")
	private Double fd_3af9f26a3cae94;
	
	@Schema(description ="预估单位生育")
	private Double fd_3af9f263e094c6;
	
	@Schema(description ="预估单位工伤")
	private Double fd_3af9f2617e530a;
	
	@Schema(description ="预估个人补缴利息")
	private Double fd_3af9f281651734;
	
	@Schema(description ="实缴单位合计")
	private Double fd_3af9f2e9208e4e;
	
	@Schema(description ="实缴单位大病救助")
	private Double fd_3af9f2e6dfb3f4;
	
	@Schema(description ="实缴个人医疗")
	private Double fd_3af9f2f8290f24;
	
	@Schema(description ="实缴单位生育")
	private Double fd_3af9f2e237f794;
	
	@Schema(description ="实缴单位补缴利息")
	private Double fd_3af9f2e45a5d78;
	
	@Schema(description ="预估个人大病救助")
	private Double fd_3af9f283a6f288;
	
	@Schema(description ="实缴单位医疗")
	private Double fd_3af9f2db1e5e16;
	
	@Schema(description ="预估个人医疗")
	private Double fd_3af9f27ce947ac;
	
	@Schema(description ="实缴个人大病救助")
	private Double fd_3af9f2ff2c9f42;
	
	@Schema(description ="预估单位失业")
	private Double fd_3af9f25f5e9cc4;
	
	@Schema(description ="预估合计")
	private Double fd_3af9f2883941b4;
	
	@Schema(description ="预估单位补缴利息")
	private Double fd_3af9f267a03bd6;
	
	@Schema(description ="实缴个人合计")
	private Double fd_3af9f303037214;
	
	@Schema(description ="实缴单位养老")
	private Double fd_3af9f2d8df88c0;
	
	@Schema(description ="预估个人失业")
	private Double fd_3af9f27efdd912;
	
	@Schema(description ="预估单位养老")
	private Double fd_3af9f257b1b586;
	
	@Schema(description ="我司到款单位")
	private String fd_3b0194c7336de0;
	
	@Schema(description ="社保ID")
	private String fd_3b0b716e771e06;
	
	@Schema(description ="是否全部结算")
	private String fd_3b1354c3add8c2;
	
	@Schema(description ="项目台账ID")
	private String fd_3b16e2f436ff98_text;
	
	@Schema(description ="项目台账ID(ID)")
	private String fd_3b16e2f436ff98;
	
	@Schema(description ="是否为BPO业务")
	private String fd_3b178e3ba5e258;
	
	@Schema(description ="单位应收")
	private Double fd_3b35a57b6e9d0a;
	
	@Schema(description ="单位应支")
	private Double fd_3b35a5b0b04d54;
	
	@Schema(description ="个人应收")
	private Double fd_3b35a57aee1428;
	
	@Schema(description ="个人应支")
	private Double fd_3b35a5b03100c4;
	
	@Schema(description ="薪酬申请编号")
	private String fd_3b3cab5f343a90;
	
	@Schema(description ="变更记录")
	private String fd_3b3e41ac916e66;
	
	@Schema(description ="创建人姓名")
	private String fd_3b438e61af0a56;
	
	@Schema(description ="缴纳地")
	private String fd_3b5cc5e697079a;
	
	@Schema(description ="社保合集ID")
	private String fd_3b6495a5ad6e10;
	
	@Schema(description ="创建时间")
	private Date createTime;
}
