/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.insurances.service.insurance.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TEmployeeInsurancePreQwDetail;
import com.yifu.cloud.plus.v1.yifu.insurances.mapper.insurances.TEmployeeInsurancePreQwDetailMapper;
import com.yifu.cloud.plus.v1.yifu.insurances.service.insurance.TEmployeeInsurancePreQwDetailService;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;

/**
 * 商险定时失败的企微
 *
 * @author hgw
 * @date 2025-08-07 17:49:14
 */
@Log4j2
@Service
public class TEmployeeInsurancePreQwDetailServiceImpl extends ServiceImpl<TEmployeeInsurancePreQwDetailMapper, TEmployeeInsurancePreQwDetail> implements TEmployeeInsurancePreQwDetailService {
	/**
	 * 商险定时失败的企微简单分页查询
	 *
	 * @param tEmployeeInsurancePreQwDetail 商险定时失败的企微
	 * @return
	 */
	@Override
	public IPage<TEmployeeInsurancePreQwDetail> getTEmployeeInsurancePreQwDetailPage(Page<TEmployeeInsurancePreQwDetail> page, TEmployeeInsurancePreQwDetail tEmployeeInsurancePreQwDetail) {
		return baseMapper.getTEmployeeInsurancePreQwDetailPage(page, tEmployeeInsurancePreQwDetail);
	}
}
