package com.yifu.cloud.plus.v1.permission.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.permission.entity.SysMenu;
import com.yifu.cloud.plus.v1.yifu.permission.vo.SysDivisionLineVo;
import com.yifu.cloud.plus.v1.yifu.permission.vo.SysDivisionVo;
import com.yifu.cloud.plus.v1.yifu.permission.vo.SysMenuSearchVo;
import com.yifu.cloud.plus.v1.yifu.permission.vo.SysTaxVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface SysMenuMapper extends BaseMapper<SysMenu> {
	/**
	 * 新权限-菜单表简单分页查询
	 *
	 * @param sysMenu 新权限-菜单表
	 * @Author: huyc
	 * @Date: 2023/8/29 14:19
	 * @return
	 */
	IPage<SysMenu> getSysMenuPage(Page<SysMenu> page, @Param("sysMenu") SysMenuSearchVo sysMenu);

	IPage<SysTaxVo> getSysTaxVoPage(Page<SysTaxVo> page, @Param("vo") SysTaxVo vo);

	/**
	 * 判断是否存在此菜单
	 *
	 * @param modelId 表单id
	 * @Author: huyc
	 * @Date: 2023/8/30 14:20
	 * @return
	 */
	long selectMenuId(@Param("modelId") String modelId);

	/**
	 * 判断是否存在此菜单视图
	 *
	 * @param modelId 表单id
	 * @Author: huyc
	 * @Date: 2023/8/30 14:20
	 * @return
	 */
	long selectViewId(@Param("viewId") String viewId,@Param("modelId") String modelId);

	/**
	 * 判断是否存在此字段
	 *
	 * @param modelId 表单id
	 * @Author: huyc
	 * @Date: 2023/8/30 14:41
	 * @return
	 */
	List<String> selectColumnList(@Param("modelId") String modelId);

	/**
	 * @param modelId
	 * @Description: 根据modelId获取菜单
	 * @Author: hgw
	 * @Date: 2023/9/11 11:48
	 * @return: com.yifu.cloud.plus.v1.yifu.permission.entity.SysMenu
	 **/
	SysMenu getSysMenuByModelId(@Param("modelId") String modelId);

	List<SysDivisionVo> getDivisions();

	List<SysDivisionLineVo> getDivisionLines();
}
