package com.yifu.cloud.plus.v1.yifu.social.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;


/**
 * @Author fxj
 * @Description 附件信息表
 * @Date 11:07 2022/6/22
**/
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_atta_info")
@Tag(name = "附件信息表")
public class TAttaInfo extends BaseEntity {
    private static final long serialVersionUID = 1L;
    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    @Schema(description = "主键")
    private String id;
    /**
     * 资源名称
     */
    @NotBlank(message = "资源名称不能为空")
    @Length(max = 50, message = "资源名称不能超过50个字符")
    @Schema(description = "资源名称")
    private String attaName;
    /**
     * 资源地址
     */
    @NotBlank(message = "资源地址不能为空")
    @Length(max = 100, message = "资源地址不能超过100个字符")
    @Schema(description = "资源地址")
    private String attaSrc;
    /**
     * 资源大小
     */
    @Schema(description = "资源大小")
    private Long attaSize;
    /**
     * 资源类型
     */
    @Length(max = 10, message = "资源类型不能超过10个字符")
    @Schema(description = "资源类型")
    private String attaType;
    /**
     * 1户配置的章；2：派单审核附件，税友单个使用，社保3医保附件；11社保增花名册模板；12社保减花名册模板；13医保增花名册模板；14医保减花名册模板
     */
    @NotBlank(message = "关系类型不能为空")
    @Length(max = 2, message = "关系类型不能超过2个字符")
    @Schema(description = "关系类型(1户配置的章；2：派单审核附件，税友单个使用，社保；3医保附件；11社保增花名册模板；12社保减花名册模板；13医保增花名册模板；14医保减花名册模板)")
    private String relationType;
    /**
     * 实体id和关系类型共同确定附件所属(9、10、21、22、23、24、25存项目档案id，0、2、26存附属表id)
     */
    @NotBlank(message = "实体id和关系类型共同确定附件所属不能为空")
    @Length(max = 32, message = "实体id和关系类型共同确定附件所属不能超过32个字符")
    @Schema(description = "实体id和关系类型共同确定附件所属")
    private String domainId;

	/**
	 * 地址URL
	 */
	@Length(max = 100, message = "地址URL不能超过100个字符")
	@Schema(description = "地址URL")
	@TableField(exist = false)
	private String attaUrl;
	/**
	 * 附件变更类型：0 新增 1 更新 2 删除 3 不变 档案编辑附件时需要告知后端是增加还是减少
	 */
	@TableField(exist = false)
	private String handleType;

	/**
	 * 其他分租名称
	 */
	@TableField(exist = false)
	private String groupName;
}
