/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.collect.Maps;
import com.yifu.cloud.plus.v1.yifu.social.entity.TSocialFriendReduceSet;
import com.yifu.cloud.plus.v1.yifu.social.mapper.TSocialFriendReduceSetMapper;
import com.yifu.cloud.plus.v1.yifu.social.service.TSocialFriendReduceSetService;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * 离职原因税友自动化配置表
 *
 * @author hgw
 * @date 2025-04-14 11:57:06
 */
@Log4j2
@Service
public class TSocialFriendReduceSetServiceImpl extends ServiceImpl<TSocialFriendReduceSetMapper, TSocialFriendReduceSet> implements TSocialFriendReduceSetService {

	@Override
	public Map<String, TSocialFriendReduceSet> getFriendReduceMap(String mvpType) {
		List<TSocialFriendReduceSet> list = baseMapper.getTSocialFriendReduceSetList(mvpType);
		// 将list转化为map
		if (list != null && !list.isEmpty()) {
			Map<String, TSocialFriendReduceSet> map = Maps.newHashMap();
			for (TSocialFriendReduceSet reduceSet : list) {
				map.put(reduceSet.getMvpKey(), reduceSet);
			}
			return map;
		}
		return null;
	}
}
