/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.archives.entity.LGuaziOfferRecord;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.vo.LGuaziOfferRecordVo;

/**
 * 瓜子offer操作日志
 *
 * @author chenyx
 * @date 2025-06-11 15:59:04
 */
public interface LGuaziOfferRecordService extends IService<LGuaziOfferRecord> {
    /**
     * 瓜子offer操作日志简单分页查询
     * @param lGuaziOfferRecord 瓜子offer操作日志
     * @return
     */
    IPage<LGuaziOfferRecord> getLGuaziOfferRecordPage(Page<LGuaziOfferRecord> page, LGuaziOfferRecord lGuaziOfferRecord);

	/**
	 * 单个增加 操作日志
	 *
	 * @param lGuaziOfferRecordVo 瓜子offer操作日志包装类
	 * 传参：记录来源(recordFrom)
	 * 	 1：手动更新状态；2：编辑offer信息；3：发送Offer查阅短信；4：发送信息收集短信；
	 * 	 5：（系统触发）收集短信发送成功更新状态；6：（系统触发）C端采集提交；7：档案审核通过；8：档案审核不通过；
	 * 	 9：发起合同申请；10：合同审核通过；11：（系统触发）合同归档；12：发送合同下载短信）
	 */
	void saveRecordOne(LGuaziOfferRecordVo lGuaziOfferRecordVo);


	/**
	 * 批量增加 操作日志
	 * 5：（系统触发）收集短信发送成功更新状态；
	 * 3：发送Offer查阅短信；
	 * 4：发送信息收集短信；
	 * 12：发送合同下载短信
	 * @param lGuaziOfferRecordVo 瓜子offer操作日志包装类
	 */
	void saveRecordBatch(LGuaziOfferRecordVo lGuaziOfferRecordVo);

}
