/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.order.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.order.entity.TOrderFileSyncLog;
import com.yifu.cloud.plus.v1.yifu.order.service.TOrderFileSyncLogService;
import com.yifu.cloud.plus.v1.yifu.order.vo.TOrderFileSyncLogSearchVo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


/**
 * 项目订单附件同步日志信息
 *
 * @author fxj
 * @date 2024-11-15 17:21:46
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/torderfilesynclog")
@Tag(name = "项目订单附件同步日志信息管理")
public class TOrderFileSyncLogController {

	private final TOrderFileSyncLogService tOrderFileSyncLogService;


	/**
	 * 简单分页查询
	 *
	 * @param page              分页对象
	 * @param tOrderFileSyncLog 项目订单附件同步日志信息
	 * @return
	 */
	@Operation(description = "简单分页查询")
	@GetMapping("/page")
	public R<IPage<TOrderFileSyncLog>> getTOrderFileSyncLogPage(Page<TOrderFileSyncLog> page, TOrderFileSyncLogSearchVo tOrderFileSyncLog) {
		return new R<>(tOrderFileSyncLogService.getTOrderFileSyncLogPage(page, tOrderFileSyncLog));
	}

}
