/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.salary.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Date;

/**
 * 最低工资配置-薪资配置4
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
@Data
public class TMinSalaryVo extends RowIndex implements Serializable {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@NotBlank(message = "id 不能为空")
	@Length(max = 32, message = "id 不能超过32 个字符")
	@ExcelAttribute(name = "id", isNotEmpty = true, errorInfo = "id 不能为空", maxLength = 32)
	@Schema(description = "id")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("id")
	private String id;
	/**
	 * 省
	 */
	@ExcelAttribute(name = "省")
	@Schema(description = "省")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("省")
	private Integer province;
	/**
	 * 市
	 */
	@ExcelAttribute(name = "市")
	@Schema(description = "市")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("市")
	private Integer city;
	/**
	 * 县
	 */
	@ExcelAttribute(name = "县")
	@Schema(description = "县")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("县")
	private Integer town;
	/**
	 * 最低工资标准
	 */
	@NotBlank(message = "最低工资标准 不能为空")
	@Length(max = 11, message = "最低工资标准 不能超过11 个字符")
	@ExcelAttribute(name = "最低工资标准", isNotEmpty = true, errorInfo = "最低工资标准 不能为空", maxLength = 11)
	@Schema(description = "最低工资标准")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("最低工资标准")
	private String salaryBase;
	/**
	 * 1.启用 2.停用
	 */
	@NotBlank(message = "1.启用 2.停用 不能为空")
	@ExcelAttribute(name = "1.启用 2.停用", isNotEmpty = true, errorInfo = "1.启用 2.停用 不能为空")
	@Schema(description = "1.启用 2.停用")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("1.启用 2.停用")
	private Integer status;
	/**
	 * 起始时间
	 */
	@ExcelAttribute(name = "起始时间", isDate = true)
	@Schema(description = "起始时间")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("起始时间")
	private Date startDate;
	/**
	 * 终止时间
	 */
	@ExcelAttribute(name = "终止时间", isDate = true)
	@Schema(description = "终止时间")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("终止时间")
	private Date endDate;

}
