/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 商险购买规则配置表
 *
 * @author fxj
 * @date 2025-04-01 10:14:09
 */
@Data
@TableName("t_auto_insur_rule_info")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "商险购买规则配置表")
public class TAutoInsurRuleInfo extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("主键")
	@Schema(description = "主键")
	private String id;
	/**
	 * 是否启用自动化：0是 1否
	 */
	@ExcelAttribute(name = "是否启用自动化", isNotEmpty = true, errorInfo = "是否启用自动化不能为空")
	@NotBlank(message = "是否启用自动化：0是 1否不能为空")
	@ExcelProperty("是否启用自动化")
	@Schema(description = "是否启用自动化：0是 1否")
	private String autoFlag;
	/**
	 * 投保方式：0自动1 手动
	 */
	@ExcelAttribute(name = "投保方式")
	@NotBlank(message = "投保方式：0自动1 手动不能为空")
	@ExcelProperty("投保方式")
	@Schema(description = "投保方式：0自动1 手动")
	private String addType;
	/**
	 * 续保方式：0自动1 手动
	 */
	@ExcelAttribute(name = "续保方式")
	@NotBlank(message = "续保方式：0自动1 手动不能为空")
	@ExcelProperty("续保方式")
	@Schema(description = "续保方式：0自动1 手动")
	private String updateType;
	/**
	 * 退保方式：0自动1 手动
	 */
	@ExcelAttribute(name = "退保方式")
	@NotBlank(message = "退保方式：0自动1 手动不能为空")
	@ExcelProperty("退保方式")
	@Schema(description = "退保方式：0自动1 手动")
	private String reduceType;
	/**
	 * 投保派单日期类型 0 入职日期前一天
	 */
	@ExcelAttribute(name = "投保派单日期类型")
	@ExcelProperty("投保派单日期类型")
	@Schema(description = "投保派单日期类型 0 入职日期前一天")
	private String addAutoType;
	/**
	 * 投保派单日期投保时间
	 */
	@ExcelAttribute(name = "投保派单日期投保时间")
	@Length(max = 10, message = "投保派单日期投保时间不能超过10个字符")
	@ExcelProperty("投保派单日期投保时间")
	@Schema(description = "投保派单日期投保时间")
	private String addAutoDate;
	/**
	 * 保单开始时间 类型 0 入职当日
	 */
	@ExcelAttribute(name = "保单开始时间类型")
	@ExcelProperty("保单开始时间类型")
	@Schema(description = "保单开始时间 类型 0 入职当日")
	private String addStartDate;
	/**
	 * 续保派单日期类型 0 上一份保单截止日期
	 */
	@ExcelAttribute(name = "续保派单日期类型")
	@ExcelProperty("续保派单日期类型")
	@Schema(description = "续保派单日期类型 0 上一份保单截止日期")
	private String updateAutoType;
	/**
	 * 续保派单日期续保时间
	 */
	@ExcelAttribute(name = "续保派单日期续保时间")
	@Length(max = 10, message = "续保派单日期续保时间不能超过10个字符")
	@ExcelProperty("续保派单日期续保时间")
	@Schema(description = "续保派单日期续保时间")
	private String updateAutoDate;
	/**
	 * 续保保单开始时间 0 上一份保单截止日期+1天
	 */
	@ExcelAttribute(name = "续保保单开始时间")
	@ExcelProperty("续保保单开始时间")
	@Schema(description = "续保保单开始时间 0 上一份保单截止日期+1天")
	private String updateStartDate;
	/**
	 * 退保派单日期类型 0 离职日期
	 */
	@ExcelAttribute(name = "退保派单日期类型")
	@ExcelProperty("退保派单日期类型")
	@Schema(description = "退保派单日期类型 0 离职日期")
	private String reduceAutoType;
	/**
	 * 退保派单日期退保时间
	 */
	@ExcelAttribute(name = "退保派单日期退保时间")
	@Length(max = 10, message = "退保派单日期退保时间不能超过10个字符")
	@ExcelProperty("退保派单日期退保时间")
	@Schema(description = "退保派单日期退保时间")
	private String reduceAutoDate;
	/**
	 * 退保保单失效时间 0 离职日期+1天
	 */
	@ExcelAttribute(name = "退保保单失效时间")
	@ExcelProperty("退保保单失效时间")
	@Schema(description = "退保保单失效时间 0 离职日期+1天")
	private String reduceStartDate;
	/**
	 * 项目配置主表ID
	 */
	@ExcelAttribute(name = "项目配置主表ID")
	@NotBlank(message = "项目配置主表ID不能为空")
	@ExcelProperty("项目配置主表ID")
	@Schema(description = "项目配置主表ID")
	private String mainId;
	/**
	 * 默认信息是否允许修改 0是 1否
	 */
	@ExcelAttribute(name = "默认信息是否允许修改", isNotEmpty = true, errorInfo = "默认信息是否允许修改不能为空")
	@NotBlank(message = "默认信息是否允许修改 0是 1否不能为空")
	@ExcelProperty("默认信息是否允许修改")
	@Schema(description = "默认信息是否允许修改 0是 1否")
	private String updateFlag;

	/**
	 * 项目编码
	 */
	@ExcelAttribute(name = "项目编码")
	@Length(max = 50, message = "项目编码不能超过50个字符")
	@ExcelProperty("项目编码")
	@Schema(description = "项目编码")
	private String deptNo;
	/**
	 * 项目ID
	 */
	@ExcelAttribute(name = "项目ID")
	@Length(max = 32, message = "项目ID不能超过32个字符")
	@ExcelProperty("项目ID")
	@Schema(description = "项目ID")
	private String deptId;
	/**
	 * 续保周期——专门为续保使用的
	 */
	@ExcelAttribute(name = "续保周期")
	@Length(max = 2, message = "续保周期不能超过2个字符")
	@ExcelProperty("续保周期")
	@Schema(description = "续保周期")
	private String renewalPeriod;

}
