package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 风险管控统计
 *
 * @author huych
 * @date 2024-09-25 10:01:06
 */
@Data
@TableName("t_risk_monitor")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "风险管控统计")
public class TRiskMonitor extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "主键")
	private String id;

	/**
	 * 项目id
	 */
	@Schema(description ="项目id")
	private String deptId;

	/**
	 * 结算主体名称
	 */
	@ExcelAttribute(name = "项目名称")
	@ExcelProperty("项目名称")
	@Schema(description = "项目名称")
	private String departName;

	/**
	 * 结算主体编码
	 */
	@ExcelAttribute(name = "项目编码")
	@NotBlank(message = "项目编码不能为空")
	@ExcelProperty("项目编码")
	@Schema(description = "项目编码")
	private String departNo;

	/**
	 * 项目状态：0正常 1停止服务 2 已冻结
	 */
	@ExcelAttribute(name = "项目状态")
	@ExcelProperty("项目状态")
	@Schema(description = "项目状态：0正常 1停止服务 2 已冻结")
	private String stopFlag;

	/**
	 * 二级指标归属
	 */
	@ExcelAttribute(name = "二级指标归属")
	@ExcelProperty("二级指标归属")
	@Schema(description = "二级指标归属")
	private String secondIndicatorBelong;

	/**
	 * 是否存在风险 0 是 1否
	 */
	@ExcelAttribute(name = "是否存在风险", maxLength = 1)
	@Length(max = 1, message = "是否存在风险 0 是 1否不能超过1个字符")
	@ExcelProperty("是否存在风险")
	@Schema(description = "是否存在风险 0 是 1否")
	private String isRisk;

	/**
	 * 可能风险点
	 */
	@ExcelAttribute(name = "可能风险点")
	@ExcelProperty("可能风险点")
	@Schema(description = "可能风险点")
	private String riskType;

	/**
	 * 在项人数
	 */
	@ExcelAttribute(name = "在项人数")
	@ExcelProperty("在项人数")
	@Schema(description = "在项人数")
	private Integer projectNum;

	/**
	 * 不在项人员有效合同数
	 */
	@ExcelAttribute(name = "不在项人员有效合同数")
	@ExcelProperty("不在项人员有效合同数")
	@Schema(description = "不在项人员有效合同数")
	private Integer unproContractNum;

	/**
	 * 在项人员有效合同数
	 */
	@ExcelAttribute(name = "在项人员有效合同数")
	@ExcelProperty("在项人员有效合同数")
	@Schema(description = "在项人员有效合同数")
	private Integer proContractNum;

	/**
	 * 不在项人员有效商险数
	 */
	@ExcelAttribute(name = "不在项人员有效商险数")
	@ExcelProperty("不在项人员有效商险数")
	@Schema(description = "不在项人员有效商险数")
	private Integer unproInsuranceNum;

	/**
	 * 在项人员有效商险数
	 */
	@ExcelAttribute(name = "在项人员有效商险数")
	@ExcelProperty("在项人员有效商险数")
	@Schema(description = "在项人员有效商险数")
	private Integer proInsuranceNum;

	/**
	 * 不在项人员有效社保数
	 */
	@ExcelAttribute(name = "不在项人员有效社保数")
	@ExcelProperty("不在项人员有效社保数")
	@Schema(description = "不在项人员有效社保数")
	private Integer unproSocialNum;

	/**
	 * 在项人员有效社保数
	 */
	@ExcelAttribute(name = "在项人员有效社保数")
	@ExcelProperty("在项人员有效社保数")
	@Schema(description = "在项人员有效社保数")
	private Integer proSocialNum;

	/**
	 * 不在项人员有效公积金数
	 */
	@ExcelAttribute(name = "不在项人员有效公积金数")
	@ExcelProperty("不在项人员有效公积金数")
	@Schema(description = "不在项人员有效公积金数")
	private Integer unproFundNum;

	/**
	 * 在项人员有效公积金数
	 */
	@ExcelAttribute(name = "在项人员有效公积金数")
	@ExcelProperty("在项人员有效公积金数")
	@Schema(description = "在项人员有效公积金数")
	private Integer proFundNum;

	/**
	 * 不在项人员有效发薪数
	 */
	@ExcelAttribute(name = "不在项人员最后一次发薪人数")
	@ExcelProperty("不在项人员最后一次发薪人数")
	@Schema(description = "不在项人员最后一次发薪人数")
	private Integer unproSalaryNum;

	/**
	 * 在项人员有效发薪数
	 */
	@ExcelAttribute(name = "在项人员最后一次发薪人数")
	@ExcelProperty("在项人员最后一次发薪人数")
	@Schema(description = "在项人员最后一次发薪人数")
	private Integer proSalaryNum;

	/**
	 * 最后发薪日期
	 */
	@ExcelAttribute(name = "最后一次发薪日期", isDate = true)
	@ExcelProperty("最后一次发薪日期")
	@Schema(description = "最后一次发薪日期")
	private String lastSalaryTime;

	/**
	 * 所属客户名称
	 */
	@ExcelAttribute(name = "客户名称", maxLength = 50)
	@Length(max = 50, message = "客户名称不能超过50个字符")
	@ExcelProperty("客户名称")
	@Schema(description = "客户名称")
	private String customerName;

	/**
	 * 所属客户编码
	 */
	@ExcelAttribute(name = "客户编码", maxLength = 50)
	@Length(max = 50, message = "客户编码不能超过50个字符")
	@ExcelProperty("客户编码")
	@Schema(description = "客户编码")
	private String customerNo;

	/**
	 * 业务类型分类
	 */
	@ExcelAttribute(name = "业务类型", maxLength = 32)
	@Length(max = 32, message = "业务类型不能超过32个字符")
	@ExcelProperty("业务类型")
	@Schema(description = "业务类型")
	private String businessPrimaryType;

	/**
	 * 业务类型二级分类
	 */
	@ExcelAttribute(name = "二级分类", maxLength = 32)
	@Length(max = 32, message = "二级分类不能超过32个字符")
	@ExcelProperty("二级分类")
	@Schema(description = "二级分类")
	private String businessSecondType;

	/**
	 * 业务类型三级分类
	 */
	@ExcelAttribute(name = "三级分类", maxLength = 32)
	@Length(max = 32, message = "三级分类不能超过32个字符")
	@ExcelProperty("三级分类")
	@Schema(description = "三级分类")
	private String businessThirdType;

	/**
	 * 条线类型
	 */
	@ExcelAttribute(name = "条线类型", maxLength = 20)
	@Length(max = 20, message = "条线类型不能超过20个字符")
	@ExcelProperty("条线类型")
	@Schema(description = "条线类型")
	private String lineType;

	/**
	 * BU归属
	 */
	@ExcelAttribute(name = "BU归属", maxLength = 20)
	@Length(max = 20, message = "BU归属不能超过20个字符")
	@ExcelProperty("BU归属")
	@Schema(description = "BU归属")
	private String buBelong;

	/**
	 * 是否删除（0否/1是）
	 */
	@Schema(description = "是否删除（0否/1是）")
	private String deleteFlag;

}
