/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TGzOfferInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.time.LocalDate;
import java.util.List;

/**
 * 瓜子offer信息接收表
 *
 * @author chenyx
 * @date 2025-06-11 15:58:37
 */
@Data
public class TGzOfferInfoVo extends TGzOfferInfo {

	/**
	 * 查询使用:接收时间开始
	 */
	private String createTimeStart;
	/**
	 * 查询使用:接收时间结束
	 */
	private String createTimeEnd;

	/**
	 * 批量发送短信使用
	 */
	@Schema(description = "瓜子状态数组")
	private List<String> statusList;

	/**
	 * 批量更新失败的offer信息列表
	 */
	@Schema(description = "更新失败的offer信息列表")
	private List<TGzOfferInfo> updateFailOfferList;

	/**
	 * 批量更新的状态的offerId列表
	 */
	@Schema(description = "批量更新的状态的offerId列表")
	private List<Integer> offerIdList;

	@Schema(description = "瓜子Offer状态查询数组")
	private String[] offerStatusArray;

	@TableField(exist = false)
	@Schema(description = "查询起")
	private int limitStart;

	@TableField(exist = false)
	@Schema(description = "查询止")
	private int limitEnd;

}
