package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeRetirement;
import com.yifu.cloud.plus.v1.yifu.archives.service.TEmployeeRetirementService;
import com.yifu.cloud.plus.v1.yifu.archives.vo.ChangeHandleFlagAllVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.ChangeHandleFlagVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TEmployeeRetirementExportVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TEmployeeRetirementSearchVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Set;

/**
 * @author wzb
 * @description 退休人员提醒
 * @date 2023-05-18 16:11:02
 */

@RestController
@RequiredArgsConstructor
@RequestMapping("/temployeeretirement" )
@Tag(name = "退休人员提醒")
public class TEmployeeRetirementController {

	private final TEmployeeRetirementService tEmployeeRetirementService;
	/**
	 * 分页查询
	 *
	 * @author wzb
	 * @param page
	 * @param searchVo
	 * @return {@link R< IPage< TEmployeeRetirement>>}
	 */
	@Operation(summary = "分页查询", description = "分页查询")
	@GetMapping("/page" )
	public R<IPage<TEmployeeRetirement>> getTEmployeeRetirementPage(Page page, TEmployeeRetirementSearchVo searchVo) {
		return R.ok(tEmployeeRetirementService.getTEmployeeRetirementPage(page,searchVo));
	}

	@Inner
	@Operation(summary = "分页查询", description = "分页查询")
	@PostMapping("/inner/retireeRemind" )
	public void retireeRemind() {
		tEmployeeRetirementService.retireeRemind();
	}

    /**
     * 批量修改状态
     *
     * @author wzb
     * @param changeHandleFlagAllVo
     * @return {@link R}
     */
	@Operation(summary = "批量修改状态", description = "修改状态")
	@PostMapping("/changeHandleFlagAll")
	public R changeHandleFlagAll( @RequestBody ChangeHandleFlagAllVo changeHandleFlagAllVo) {
		return R.ok(tEmployeeRetirementService.changeHandleFlagAll(changeHandleFlagAllVo));
	}

	/**
	 * 修改状态
	 *
	 * @author wzb
	 * @param changeHandleFlagVo
	 * @return {@link R}
	 */
	@Operation(summary = "修改状态", description = "修改状态")
	@PostMapping("/changeHandleFlag")
	public R changeHandleFlag(@RequestBody ChangeHandleFlagVo changeHandleFlagVo) {
		return R.ok(tEmployeeRetirementService.changeHandleFlag(changeHandleFlagVo));
	}


	/**
	 * 修改状态
	 */
	@Operation(summary = "操作日志详情", description = "操作日志详情")
	@GetMapping("/getHandleFlagDetail")
	public R getHandleFlagDetail(String id) {
		return R.ok(tEmployeeRetirementService.getHandleFlagDetail(id));
	}

	/**
	 * 人员退休提醒批量导出
	 *
	 * @author wzb
	 * @param response
	 * @param searchVo
	 * @return void
	 */
	@Operation(summary = "人员退休提醒批量导出", description = "人员退休提醒批量导出")
	@GetMapping("/export")
	public void export(HttpServletResponse response, TEmployeeRetirementSearchVo searchVo) {
		tEmployeeRetirementService.listExport(response, searchVo);
	}

}
