/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.ekp.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.ekp.entity.EkpZhaoHangDetail;
import com.yifu.cloud.plus.v1.ekp.mapper.EkpZhaoHangDetailMapper;
import com.yifu.cloud.plus.v1.ekp.service.EkpZhaoHangDetailService;
import com.yifu.cloud.plus.v1.yifu.admin.api.vo.KeyValueVo;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 招行卡
 *
 * @author hgw
 * @date 2025-09-09 16:22:40
 */
@Log4j2
@Service
public class EkpZhaoHangDetailServiceImpl extends ServiceImpl<EkpZhaoHangDetailMapper, EkpZhaoHangDetail> implements EkpZhaoHangDetailService {

	@Override
	public List<String> getByNo(List<String> noList) {
		return baseMapper.getByNo(noList);
	}

	/**
	 * @Description: 返回招行账号ID与EKP用户ID的Map
	 * @Author: hgw
	 * @Date: 2025/9/9 18:02
	 * @return: java.util.Map<java.lang.String, java.lang.String>
	 **/
	@Override
	public Map<String, String> getAccountIdAndUserId() {
		List<KeyValueVo> list = baseMapper.getAccountIdAndUserId();
		Map<String, String> returnMap = new HashMap<>();
		if (list != null && !list.isEmpty()) {
			for (KeyValueVo keyValueVo : list) {
				returnMap.put(keyValueVo.getKeyStr(), keyValueVo.getValueStr());
			}
		}
		return returnMap;
	}
}
