package com.yifu.cloud.plus.v1.yifu.insurances.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.time.LocalDate;


/**
 * @author licancan
 * @description 商险明细表 t_insurance_detail
 * @date 2022-07-18 16:20:16
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_insurance_alert")
@Schema(description = "商险到期提醒表")
public class TInsuranceAlert extends BaseEntity {
    /**
     * 主键
     */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "主键")
    private String id;

    /**
     * 员工姓名
     */
	@Schema(description = "员工姓名")
    private String empName;

    /**
     * 员工身份证号
     */
	@Schema(description = "员工身份证号")
    private String empIdcardNo;

	/**
	 * 项目编码
	 */
	@Schema(description = "项目编码")
    private String deptNo;

	/**
	 * 投保岗位
	 */
	@Schema(description = "投保岗位")
	private String post;

    /**
     * 保险公司名称(冗余字段)
     */
	@Schema(description = "保险公司名称")
    private String insuranceCompanyName;

    /**
     * 险种名称
     */
	@Schema(description = "险种名称")
    private String insuranceTypeName;

    /**
     * 购买标准
     */
	@Schema(description = "购买标准")
    private String buyStandard;

	/**
	 * 医疗额度
	 */
	@Schema(description = "医疗额度")
	private String medicalQuota;

	/**
	 * 身故或残疾额度
	 */
	@Schema(description = "身故或残疾额度")
	private String dieDisableQuota;

    /**
     * 保单编号
     */
	@Schema(description = "保单编号")
    private String policyNo;

    /**
     * 保单开始时间
     */
	@Schema(description = "保单开始时间")
    private LocalDate policyStart;

    /**
     * 保单结束时间
     */
	@Schema(description = "保单结束时间")
    private LocalDate policyEnd;

    /**
     * 保单生效日期
     */
	@Schema(description = "保单生效日期")
    private LocalDate policyEffect;

	/**
	 * 结算月
	 */
	@Schema(description = "结算月")
	private String settleMonth;

    /**
     * 发票号
     */
	@Schema(description = "发票号")
    private String invoiceNo;

	/**
	 * 商险购买地省
	 */
	@Schema(description = "商险购买地省")
    private String insuranceProvinceName;

	/**
	 * 商险购买地市
	 */
	@Schema(description = "商险购买地市")
    private String insuranceCityName;

	/**
	 * 商险办理省
	 */
	@Schema(description = "商险办理省")
    private String insuranceHandleProvinceName;

	/**
	 * 商险办理城市
	 */
	@Schema(description = "商险办理城市")
    private String insuranceHandleCityName;

    /**
     * 结算类型 (0、与薪资合并结算 1、单独结算)
     */
	@Schema(description = "结算类型 (0、与薪资合并结算 1、单独结算)")
    private Integer settleType;

    /**
     * 实际保费
     */
	@Schema(description = "实际保费")
    private BigDecimal actualPremium;

    /**
     * 预估保费
     */
	@Schema(description = "预估保费")
    private BigDecimal estimatePremium;

    /**
     * 是否过期 0未过期 1已过期
     */
	@Schema(description = "是否过期 0未过期 1已过期")
    private Integer isOverdue;

	@Schema(description = "是否有效 0有效 1无效")
	private Integer isEffect;

	/**
	 * 备注
	 */
	@Schema(description = "备注")
    private String remark;

    /**
     * 是否删除 0未删除/1删除
     */
	@Schema(description = "是否删除 0否/1是")
    private Integer deleteFlag;

	/**
	 * 创建人所在部门名称
	 */
	@Schema(description = "创建人所在部门名称")
	private String createUserDeptName;

	@Schema(description = "项目名称")
	private String deptName;

	@Schema(description ="客户名称")
	private String unitName;

	@Schema(description ="客户编码")
	private String unitNo;

	/**
	 * 忽略提醒 0：忽略 1：不忽略
	 */
	@Schema(description = "有忽略提醒 0：忽略 1：不忽略")
	private String expireIgnoreFlag;

	/**
	 * 消息提醒备注
	 */
	@Schema(description = "消息提醒备注")
	private String expireRemark;

	/**
	 * 消息提醒人
	 */
	@Schema(description = "消息提醒人")
	private String alerter;

	/**
	 * 消息提醒人ID
	 */
	@Schema(description = "消息提醒人ID")
	private String alertId;
	/**
	 * 距离到期剩余工作日
	 */
	@Schema(description = "距离到期剩余工作日")
	private String haveWorkDay;

	private static final long serialVersionUID = 1L;
}