package com.yifu.cloud.plus.v1.yifu.social.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 失败原因配置
 *
 * @author huyc
 * @date 2024-05-08 10:41:32
 */
@Data
@TableName("fail_reason_config")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "失败原因配置")
public class FailReasonConfig extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("主键")
	@Schema(description = "主键")
	private String id;
	/**
	 * 失败原因
	 */
	@ExcelAttribute(name = "失败原因", isNotEmpty = true, errorInfo = "失败原因不能为空", maxLength = 200)
	@NotBlank(message = "失败原因不能为空")
	@Length(max = 200, message = "失败原因不能超过200个字符")
	@ExcelProperty("失败原因")
	@Schema(description = "失败原因")
	private String reason;
	/**
	 * 关键字
	 */
	@ExcelAttribute(name = "关键字", maxLength = 20)
	@Length(max = 20, message = "关键字不能超过20个字符")
	@ExcelProperty("关键字")
	@Schema(description = "关键字")
	private String reasonKey;
	/**
	 * 精简原因
	 */
	@ExcelAttribute(name = "精简原因", isNotEmpty = true, errorInfo = "精简原因不能为空", maxLength = 200)
	@NotBlank(message = "精简原因不能为空")
	@Length(max = 200, message = "精简原因不能超过200个字符")
	@ExcelProperty("精简原因")
	@Schema(description = "精简原因")
	private String simpleReason;
	/**
	 * 重新办理动作 1 继续办理 2 中止办理 3 人工办理
	 */
	@ExcelAttribute(name = "重新办理动作", isNotEmpty = true, errorInfo = "重新办理动作不能为空", maxLength = 1)
	@NotBlank(message = "重新办理动作不能为空")
	@Length(max = 1, message = "重新办理动作不能超过1个字符")
	@ExcelProperty("重新办理动作")
	@Schema(description = "重新办理动作")
	private String replay;
	/**
	 * 状态 0 正常 1 禁用
	 */
	@ExcelAttribute(name = "状态", maxLength = 1)
	@Length(max = 1, message = "状态不能超过1个字符")
	@ExcelProperty("状态")
	@Schema(description = "状态")
	private String status;
	/**
	 * 更新人
	 */
	@ExcelAttribute(name = "更新人")
	@ExcelProperty("更新人")
	@Schema(description = "更新人")
	private String updateName;

	/**
	 * 是否截取：0否；1是
	 */
	@ExcelAttribute(name = "是否截取")
	@ExcelProperty("是否截取")
	@Schema(description = "是否截取")
	private String isReplace;
	/**
	 * 截取标识左
	 */
	@ExcelAttribute(name = "截取标识左")
	@ExcelProperty("截取标识左")
	@Schema(description = "截取标识左")
	private String replaceLeft;
	/**
	 * 截取标识右
	 */
	@ExcelAttribute(name = "截取标识右")
	@ExcelProperty("截取标识右")
	@Schema(description = "截取标识右")
	private String replaceRight;

	// 户ID
	@TableField(exist = false)
	private String huId;

}