package com.yifu.cloud.plus.v1.yifu.insurances.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.util.DateUtil;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 * @Author fxj
 * @Description 保单维护导入对象
 * @Date 16:34 2025/8/29
**/
@Data
@Schema(description = "保单维护导入对象")
public class InsurancePolicyImportVo  extends RowIndex implements Serializable {
	private static final long serialVersionUID = 1442112261102562729L;
	/**
	 * 保单号
	 */
	@Length(max = 50, message = "保单号 不能超过50 个字符" )
	@ExcelAttribute(name = "保单号", maxLength = 50, isNotEmpty = true,errorInfo = "保单号不能为空")
	@ExcelProperty("保单号" )
	@Schema(description = "保单号")
	private String policyNo;

	/**
	 * 保单开始日期
	 */
	@ExcelAttribute(name = "保单开始日期",isDate = true,  isNotEmpty = true,dateFormat = DateUtil.ISO_EXPANDED_DATE_FORMAT, errorInfo = "保单开始日期不能为空")
	@ExcelProperty("保单开始日期" )
	@Schema(description = "保单开始日期")
	private String policyStart;

	/**
	 * 保单截止日期
	 */
	@ExcelAttribute(name = "保单截止日期", isDate = true, isNotEmpty = true,dateFormat = DateUtil.ISO_EXPANDED_DATE_FORMAT,errorInfo = "保单截止日期不能为空")
	@ExcelProperty("保单截止日期" )
	@Schema(description = "保单截止日期")
	private String policyEnd;

	/**
	 * 保险公司
	 */
	@ExcelAttribute(name = "保险公司", maxLength = 60, isNotEmpty = true,errorInfo = "保险公司不能为空")
	@ExcelProperty("保险公司" )
	@Schema(description = "保险公司")
	private String insuranceCompanyName;

	/**
	 * 险种
	 */
	@ExcelAttribute(name = "险种", maxLength = 50, isNotEmpty = true,errorInfo = "险种不能为空")
	@ExcelProperty("险种" )
	@Schema(description = "险种")
	private String insuranceTypeName;
}
