package com.yifu.cloud.plus.v1.yifu.permission.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.apache.poi.hpsf.Decimal;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * E人事项目加班申请
 * @author chenyuxi
 * @since  1.9.6
 * @date   2025-02-06
 */
@TableName(value = "ekp_qiwei_workovertime")
@Data
@Schema(description = "E人事项目加班申请")
public class EkpQiwiWorkovertime {

	@TableField(exist = false)
	private static final long serialVersionUID = 1L;

	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "主键", name = "fdId")
	private String fdId;

	@Schema(description = "申请编号")
	@NotBlank(message = "申请编号不能为空")
	private String fdSpNo;

	@Schema(description = "申请人姓名")
	@NotBlank(message = "申请人姓名不能为空")
	private String fdApplyUserName;

	@Schema(description = "申请人部门")
	@NotBlank(message = "申请人部门不能为空")
	private String fdApplyUserDept;

	@Schema(description = "申请日期")
	@NotNull(message = "申请日期不能为空")
	private LocalDateTime fdApplyDate;

	@Schema(description = "加班开始时间")
	private LocalDateTime fdWorkBegin;
	@Schema(description = "加班结束时间")
	private LocalDateTime fdWorkEnd;

	@Schema(description = "加班事由")
	private String fdReason;
	@Schema(description = "加班时间用于")
	private String fdTimeUse;
	@Schema(description = "岗位级别")
	private String fdPositionLevel;
	@Schema(description = "项目名称")
	private String fdProjectName;
	@Schema(description = "项目编码")
	private String fdProjectCode;

	@Schema(description = "工作日加班时长（小时）")
	private String fdWorkDuration;
	@Schema(description = "节假日加班时长（小时）")
	private String fdHolidayDuration;
	@Schema(description = "休息日加班时长（小时）")
	private String fdRestDuration;
	@Schema(description = "累计加班时长（小时）")
	private String fdSumDuration;
	@Schema(description = "是否出差加班：是、否")
	private String fdIsAway;

	@Schema(description = "关联加班费状态")
	private String fdOvertimePayStatus;
	@Schema(description = "关联加班费的项目报销单号ID")
	private String fdOvertimePayId;
	@Schema(description = "关联加班费的项目报销单号编号")
	private String fdOvertimePayCode;
	@Schema(description = "关联加班餐费状态")
	private String fdOvertimeFoodStatus;
	@Schema(description = "关联加班餐费的项目报销单号ID")
	private String fdOvertimeFoodId;
	@Schema(description = "关联加班餐费的项目报销单号编号")
	private String fdOvertimeFoodCode;

	@Schema(description = "拉取数据时间")
	private LocalDateTime createTime;
	@Schema(description = "原始数据存储")
	private String orgData;
}
