package com.yifu.cloud.plus.v1.yifu.social.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * 合同自动化企微日志表
 *
 * @author huych
 * @date 2025-10-20 20:03:58
 */
@Data
@TableName("t_social_auto_log")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "合同自动化企微日志表")
public class TSocialAutoLog extends BaseEntity {

	/**
	 * ID
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("ID")
	@Schema(description = "ID")
	private String id;
	@Schema(description = "社保实时ID")
	private String socialId;
	/**
	 * 员工姓名
	 */
	@ExcelAttribute(name = "员工姓名", maxLength = 50)
	@Length(max = 50, message = "员工姓名不能超过50个字符")
	@ExcelProperty("员工姓名")
	@Schema(description = "员工姓名")
	private String empName;
	/**
	 * 员工身份证
	 */
	@ExcelAttribute(name = "员工身份证", maxLength = 20)
	@Length(max = 20, message = "员工身份证不能超过20个字符")
	@ExcelProperty("员工身份证")
	@Schema(description = "员工身份证")
	private String empIdcard;
	/**
	 * 入职日期
	 */
	@ExcelAttribute(name = "入职日期", isDate = true)
	@ExcelProperty("入职日期")
	@Schema(description = "入职日期")
	private Date joinLeaveDate;
	/**
	 * 手机号码
	 */
	@ExcelAttribute(name = "手机号码", maxLength = 30)
	@Length(max = 30, message = "手机号码不能超过30个字符")
	@ExcelProperty("手机号码")
	@Schema(description = "手机号码")
	private String phone;
	/**
	 * 异常原因说明
	 */
	@ExcelAttribute(name = "异常原因说明", maxLength = 200)
	@Length(max = 200, message = "异常原因说明不能超过200个字符")
	@ExcelProperty("异常原因说明")
	@Schema(description = "异常原因说明")
	private String errorInfo;

}
