/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.write.style.ColumnWidth;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;

/**
 * HCM档案子Vo
 *
 * @author hgw
 * @date 2023-11-23 12:02:03
 */
@Data
@ColumnWidth(30)
public class HcmArchiveEducationVo implements Serializable {

	private static final long serialVersionUID = 1L;
	// 学校
	@Schema(description = "学校名称")
	private String schoolName;
	// 工作部门
	@Schema(description = "专业")
	private String major;
	// 工作岗位
	@Schema(description = "学历")
	private String education;
	// 入学时间
	@Schema(description = "入校日期")
	private String joinDate;
	// 毕业时间
	@Schema(description = "毕业日期")
	private String leaveDate;
	// 学制类型
	@Schema(description = "是否全日制")
	private String isFullTime;
	// 附件
	@Schema(description = "学历附件")
	private String annex;

}
