/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmpChangeInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;

/**
 * 档案划转日志表
 *
 * @author huyc
 * @date 2022-06-22
 */
@Data
public class TEmpChangeInfoNewVO implements Serializable {

	private static final long serialVersionUID = 1L;
	/**
	 * 员工姓名
	 */
	@Schema(description ="员工姓名")
	private String empName;

	/**
	 * 原单位名称
	 */
	@Schema(description ="原单位名称")
	private String oldUnitName;

	/**
	 * 新单位名称
	 */
	@Schema(description ="新单位名称")
	private String newUnitName;

	/**
	 * 原项目
	 */
	@Schema(description ="原项目名称")
	private String oldDeptName;

	/**
	 * 新项目
	 */
	@Schema(description ="新项目名称")
	private String newDeptName;

	/**
	 * 项目档案id
	 */
	@Schema(description ="项目档案id")
	private String proId;

	/**
	 * 项目id
	 */
	@Schema(description ="项目id")
	@TableField(exist = false)
	private String oldDepartId;

	/**
	 * 项目id
	 */
	@Schema(description ="项目id")
	@TableField(exist = false)
	private String oldDepartNo;

	/**
	 * 客户id
	 */
	@Schema(description ="客户id")
	@TableField(exist = false)
	private String oldCustomerId;

	/**
	 * 身份证号码
	 */
	@Schema(description ="身份证号码")
	private String empIdcard;

	/**
	 * 客户id
	 */
	@Schema(description ="客户id")
	@TableField(exist = false)
	private String newUnitId;

	/**
	 * 客户编码
	 */
	@Schema(description ="客户编码")
	@TableField(exist = false)
	private String newUnitNo;

	/**
	 * 项目id
	 */
	@Schema(description ="项目id")
	@TableField(exist = false)
	private String newDeptId;

	/**
	 * 项目编码
	 */
	@Schema(description ="项目编码")
	@TableField(exist = false)
	private String newDeptNo;
	/**
	 * 划转项：0 员工合同 1 社保  2 公积金
	 */
	@Schema(description = "划转项：0 员工合同 1 社保  2 公积金")
	private String changeItems;

	/**
	 * 原项目处理：0 不处理  1 同步减项
	 */
	@Schema(description = "原项目处理：0 不处理  1 同步减项")
	private String changeType;

}
