/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TCompanyInfo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

/**
 * 收入证明 中的 单位信息维护表
 *
 * @author fxj
 * @date 2023-08-23 17:31:05
 */
@Mapper
public interface TCompanyInfoMapper extends BaseMapper<TCompanyInfo> {
	/**
	 * 收入证明 中的 单位信息维护表简单分页查询
	 *
	 * @param tCompanyInfo 收入证明 中的 单位信息维护表
	 * @return
	 */
	IPage<TCompanyInfo> getTCompanyInfoPage(Page<TCompanyInfo> page, @Param("tCompanyInfo") TCompanyInfo tCompanyInfo);
}
