package com.yifu.cloud.plus.v1.business.service.salary;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.business.entity.salary.TBusSalary;
import com.yifu.cloud.plus.v1.business.vo.salary.BusSalaryExportVo;
import com.yifu.cloud.plus.v1.business.vo.salary.SalaryImportVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;

import java.util.List;

/**
 * B端-薪酬主表
 *
 * @author hgw
 * @date 2021-09-06 11:10:32
 */
public interface TBusSalaryService extends IService<TBusSalary> {

     /**
      * B端-薪酬主表简单分页查询
      *
      * @param tBusSalary B端-薪酬主表
      * @return
      */
     IPage<TBusSalary> getTBusSalaryPage(Page<TBusSalary> page, TBusSalary tBusSalary);

     /**
      * @param tBusSalary
      * @Description: 导出
      * @Author: hgw
      * @Date: 2021/9/13 17:16
      * @return: com.yifu.cloud.v1.hrobusiness.api.vo.salary.BusSalaryExportVo
      **/
     BusSalaryExportVo doExport(TBusSalary tBusSalary);

     /**
      * @param salaryVo
      * @Description: 导入
      * @Author: hgw
      * @Date: 2021/9/6 16:25
      * @return: com.yifu.cloud.v1.common.core.util.R<java.util.List < java.util.List < com.yifu.cloud.v1.common.core.util.bean.ErrorMessage>>>
      **/
     R<List<ErrorMessage>> importBusSalary(SalaryImportVo salaryVo);

}
