/*
 * Copyright (c) 2020 yifu4cloud Authors. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.yifu.cloud.plus.v1.yifu.admin.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysDataAuth;
import com.yifu.cloud.plus.v1.yifu.admin.api.vo.SysDataAuthVO;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;

import java.util.List;

/**
 * @Description: 数据权限配置接口
 * @Author: hgw
 * @Date: 2022/6/8 17:15
 **/
public interface SysDataAuthService extends IService<SysDataAuth> {

	void refreshAuth(SysDataAuth sysDataAuth);

	/**
	 * @Description: 分页查询
	 * @Author: hgw
	 * @Date: 2022/6/7 14:45
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysDataAuth>
	 **/
	IPage<SysDataAuth> getSysDataAuthPage(Page<SysDataAuth> page, SysDataAuth sysDataAuth);

	/**
	 * @Description: 获取list
	 * @Author: hgw
	 * @Date: 2022/6/9 16:47
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysDataAuth>
	 **/
	List<SysDataAuth> getSysDataAuthList(SysDataAuth sysDataAuth);

	/**
	 * @Description: 新增
	 * @Author: hgw
	 * @Date: 2022/6/7 14:46
	 * @return: java.lang.Boolean
	 **/
	R<String> saveDataAuth(SysDataAuthVO sysDataAuthVO);

	/**
	 * @param id
	 * @Description: 删除
	 * @Author: hgw
	 * @Date: 2022/6/7 14:46
	 * @return: java.lang.Boolean
	 **/
	Boolean removeDataAuthById(String id);

	/**
	 * @param mainId
	 * @Description: 查看
	 * @Author: hgw
	 * @Date: 2022/6/9 14:52
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<com.yifu.cloud.plus.v1.yifu.admin.api.vo.SysDataAuthVO>
	 **/
	R<SysDataAuthVO> getByMainId(String mainId);

}
