/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 瓜子offer操作日志
 *
 * @author chenyx
 * @date 2025-06-11 15:59:04
 */
@Data
@TableName("l_guazi_offer_record")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "瓜子offer操作日志")
public class LGuaziOfferRecord extends BaseEntity {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "id")
	private String id;
	/**
	 * 关联瓜子offerID
	 */
	@Schema(description = "关联瓜子offerID")
	private Integer offerId;
	/**
	 * 操作内容
	 */
	@NotBlank(message = "操作内容不能为空")
	@Schema(description = "操作内容")
	private String content;
	/**
	 * 记录来源
	 * （1：手动更新状态；2：编辑offer信息；3：发送Offer查阅短信；4：发送信息收集短信；5：收集短信发送成功；6：（系统触发）C端采集提交；
	 * 7：档案审核；9：发起合同申请10：合同审核通过；11：合同归档；12：发送合同下载短信）
	 */
	@Length(max = 2, message = "记录来源不能超过2个字符")
	@Schema(description = "记录来源（1：手动更新状态；2：编辑offer信息；3：发送Offer查阅短信；4：发送信息收集短信；5：收集短信发送成功；6：（系统触发）C端采集提交；7：档案审核通过；9：发起合同申请10：合同审核通过；11：合同归档；12：发送合同下载短信）")
	private String recordFrom;
	/**
	 * 删除标记
	 */
	@Length(max = 1, message = "删除标记不能超过1个字符")
	@Schema(description = "删除标记")
	@TableLogic
	private String delFlag;

}
