package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author fxj
 * @Date 2022/6/29
 * @Description
 * @Version 1.0
 */
@Data
public class EmpBadRecordVo extends RowIndex implements Serializable {
	/**
	 * 员工姓名
	 */
	@ExcelAttribute(name = "员工姓名" ,maxLength = 20, isNotEmpty = true)
	@Schema(description ="员工姓名")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工姓名")
	private String empName;

	/**
	 * 身份证号
	 */
	@ExcelAttribute(name = "身份证号" ,maxLength = 20, isNotEmpty = true)
	@Schema(description ="身份证号")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证号")
	private String empIdcard;

	/**
	 * 产生项目
	 */
	@Schema(description ="产生项目")
	@ExcelIgnore
	private String project;

	/**
	 * 项目编码
	 */
	@ExcelAttribute(name = "产生项目编码" ,maxLength = 50)
	@Schema(description ="产生项目编码")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("产生项目编码")
	private String projectCode;

	/**
	 * 发生时间
	 */
	@ExcelAttribute(name = "发生时间")
	@Schema(description ="发生时间")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("发生时间")
	private Date happenTime;

	/**
	 * 备注
	 */
	@ExcelAttribute(name = "不良记录描述", maxLength = 200)
	@Schema(description ="不良记录描述")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("不良记录描述")
	private String remark;

	/**
	 * 费用损失 （费用损失与其他费用损失其一必填）
	 */
	@ExcelAttribute(name = "费用损失" , isFloat = true,max = "999999999.99")
	@Schema(description ="费用损失 （费用损失与其他费用损失其一必填）")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("费用损失")
	private BigDecimal loseFee;

	/**
	 * 其他损失 （费用损失与其他费用损失其一必填）
	 */
	@ExcelAttribute(name = "其他损失" , isFloat = true,max = "999999999.99")
	@Schema(description ="其他损失 （费用损失与其他费用损失其一必填）")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("其他损失")
	private BigDecimal loseFeeOther;

	/**
	 * 是否曾经或正在追究与承担过刑事责任 0 是 1 否
	 */
	@ExcelAttribute(name = "是否有不良记录" , isNotEmpty = true,readConverterExp = "0=是,1=否")
	@Schema(description ="是否曾经或正在追究与承担过刑事责任 0 是 1 否 ")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("是否有不良记录")
	private String badRecordFlag;

}
