package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 * @Author fxj
 * @Date 2023/10/17
 * @Description 社保公积金审核权限VO
 * @Version 1.0
 */
@Data
public class SocialAuthHandleImportVo extends RowIndex implements Serializable {
	@ExcelAttribute(name = "登录账号", maxLength = 30,isNotEmpty = true)
	@Schema(description = "登录账号")
	private String userLoginName;


	@Length(max = 32, message = "户名称不能超过32个字符")
	@ExcelAttribute(name = "户名称", maxLength = 32,isNotEmpty = true)
	@Schema(description = "户名称")
	private String houseHold;
}
