/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author fxj
 * @date 2025-04-07 10:24:30
 */
@Data
public class TAutoStandardInfoVo extends RowIndex implements Serializable {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@NotBlank(message = "主键 不能为空")
	@Length(max = 32, message = "主键 不能超过32 个字符")
	@ExcelAttribute(name = "主键", isNotEmpty = true, errorInfo = "主键 不能为空", maxLength = 32)
	@Schema(description = "主键")
	@ExcelProperty("主键")
	private String id;
	/**
	 * 关联主表ID
	 */
	@NotBlank(message = "关联主表ID 不能为空")
	@Length(max = 32, message = "关联主表ID 不能超过32 个字符")
	@ExcelAttribute(name = "关联主表ID", isNotEmpty = true, errorInfo = "关联主表ID 不能为空", maxLength = 32)
	@Schema(description = "关联主表ID")
	@ExcelProperty("关联主表ID")
	private String mainId;
	/**
	 * 购买标准
	 */
	@NotBlank(message = "购买标准 不能为空")
	@ExcelAttribute(name = "购买标准", isNotEmpty = true, errorInfo = "购买标准 不能为空")
	@Schema(description = "购买标准")
	@ExcelProperty("购买标准")
	private BigDecimal standard;

}
