/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TCompleteMonitorSet;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 完整度监控配置
 *
 * @author hgw
 * @date 2025-02-26 15:18:51
 */
@Mapper
public interface TCompleteMonitorSetMapper extends BaseMapper<TCompleteMonitorSet> {
	/**
	 * 完整度监控配置简单分页查询
	 *
	 * @param tCompleteMonitorSet 完整度监控配置
	 * @return
	 */
	IPage<TCompleteMonitorSet> getTCompleteMonitorSetPage(Page<TCompleteMonitorSet> page, @Param("tCompleteMonitorSet") TCompleteMonitorSet tCompleteMonitorSet);
	// 获取全部配置
	List<TCompleteMonitorSet> getAllList();

	// 获取已配置的合同类型
	String getAllUseContractType(@Param("oldId") String oldId);

}
