/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TGzEmpContactInfo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 瓜子紧急联系人
 *
 * @author chenyx
 * @date 2025-06-13 15:19:04
 */
@Mapper
public interface TGzEmpContactInfoMapper extends BaseMapper<TGzEmpContactInfo> {
    /**
     * 瓜子紧急联系人简单分页查询
     * @param tGzEmpContactInfo 瓜子紧急联系人
     * @return
     */
    IPage<TGzEmpContactInfo> getTGzEmpContactInfoPage(Page<TGzEmpContactInfo> page, @Param("tGzEmpContactInfo") TGzEmpContactInfo tGzEmpContactInfo);

	// 获取附属信息——保存到人员档案时使用 hgw
	TGzEmpContactInfo getOneByEmpId(@Param("empId") String empId);

	// 保存是先删后增 hgw 2025-6-20 11:06:38
	int deleteByEmpId(@Param("empId") String empId);

}
